/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.MarkerFiles;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackHelper;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.upgrade.UpgradeHandler;

public class ZeroToOneUpgradeHandler
implements UpgradeHandler {
    public void upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime) {
        HoodieFlinkTable table = HoodieFlinkTable.create(config, (HoodieFlinkEngineContext)context);
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingCompaction();
        List commits = inflightTimeline.getReverseOrderedInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        if (commits.size() > 0 && instantTime != null) {
            commits.remove(instantTime);
        }
        for (String commit : commits) {
            ZeroToOneUpgradeHandler.recreateMarkerFiles(commit, table, context, config.getMarkersDeleteParallelism());
        }
    }

    private static void recreateMarkerFiles(String commitInstantTime, HoodieFlinkTable table, HoodieEngineContext context, int parallelism) throws HoodieRollbackException {
        try {
            Option commitInstantOpt = Option.fromJavaOptional(table.getActiveTimeline().getCommitsTimeline().getInstants().filter(instant -> HoodieActiveTimeline.EQUALS.test(instant.getTimestamp(), commitInstantTime)).findFirst());
            if (commitInstantOpt.isPresent()) {
                MarkerFiles markerFiles = new MarkerFiles((HoodieTable)table, commitInstantTime);
                markerFiles.quietDeleteMarkerDir(context, parallelism);
                List rollbackRequests = table.getMetaClient().getTableType() == HoodieTableType.COPY_ON_WRITE ? RollbackUtils.generateRollbackRequestsByListingCOW((HoodieEngineContext)context, (String)table.getMetaClient().getBasePath(), (HoodieWriteConfig)table.getConfig()) : RollbackUtils.generateRollbackRequestsUsingFileListingMOR((HoodieInstant)((HoodieInstant)commitInstantOpt.get()), (HoodieTable)table, (HoodieEngineContext)context);
                List<HoodieRollbackStat> rollbackStats = new ListingBasedRollbackHelper(table.getMetaClient(), table.getConfig()).collectRollbackStats(context, (HoodieInstant)commitInstantOpt.get(), rollbackRequests);
                for (HoodieRollbackStat rollbackStat : rollbackStats) {
                    for (String path : rollbackStat.getSuccessDeleteFiles()) {
                        String dataFileName = path.substring(path.lastIndexOf("/") + 1);
                        markerFiles.create(rollbackStat.getPartitionPath(), dataFileName, IOType.MERGE);
                    }
                    for (FileStatus fileStatus : rollbackStat.getCommandBlocksCount().keySet()) {
                        markerFiles.create(rollbackStat.getPartitionPath(), ZeroToOneUpgradeHandler.getFileNameForMarkerFromLogFile(fileStatus.getPath().toString(), table), IOType.APPEND);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Exception thrown while upgrading Hoodie Table from version 0 to 1", (Throwable)e);
        }
    }

    private static String getFileNameForMarkerFromLogFile(String logFilePath, HoodieTable table) {
        Path logPath = new Path(table.getMetaClient().getBasePath(), logFilePath);
        String fileId = FSUtils.getFileIdFromLogPath((Path)logPath);
        String baseInstant = FSUtils.getBaseCommitTimeFromLogPath((Path)logPath);
        String writeToken = FSUtils.getWriteTokenFromLogPath((Path)logPath);
        return FSUtils.makeDataFileName((String)baseInstant, (String)writeToken, (String)fileId, (String)table.getBaseFileFormat().getFileExtension());
    }
}

