/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row.parquet;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.io.storage.row.parquet.ParquetSchemaConverter;
import org.apache.parquet.schema.MessageType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestParquetSchemaConverter {
    @Test
    void testConvertComplexTypes() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.CHAR((int)10))), DataTypes.FIELD((String)"f_map", (DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.VARCHAR((int)20))), DataTypes.FIELD((String)"f_row", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_row_f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_row_f1", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_row_f2", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_row_f2_f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_row_f2_f1", (DataType)DataTypes.VARCHAR((int)10))}))}))});
        MessageType messageType = ParquetSchemaConverter.convertToParquetMessageType((String)"converted", (RowType)((RowType)dataType.getLogicalType()));
        MatcherAssert.assertThat((Object)messageType.getColumns().size(), (Matcher)CoreMatchers.is((Object)7));
        String expected = "message converted {\n  optional group f_array (LIST) {\n    repeated group array {\n      optional binary element (STRING);\n    }\n  }\n  optional group f_map (MAP) {\n    repeated group key_value {\n      required int32 key;\n      optional binary value (STRING);\n    }\n  }\n  optional group f_row {\n    optional int32 f_row_f0;\n    optional binary f_row_f1 (STRING);\n    optional group f_row_f2 {\n      optional int32 f_row_f2_f0;\n      optional binary f_row_f2_f1 (STRING);\n    }\n  }\n}\n";
        MatcherAssert.assertThat((Object)messageType.toString(), (Matcher)CoreMatchers.is((Object)"message converted {\n  optional group f_array (LIST) {\n    repeated group array {\n      optional binary element (STRING);\n    }\n  }\n  optional group f_map (MAP) {\n    repeated group key_value {\n      required int32 key;\n      optional binary value (STRING);\n    }\n  }\n  optional group f_row {\n    optional int32 f_row_f0;\n    optional binary f_row_f1 (STRING);\n    optional group f_row_f2 {\n      optional int32 f_row_f2_f0;\n      optional binary f_row_f2_f1 (STRING);\n    }\n  }\n}\n"));
    }

    @Test
    void testConvertTimestampTypes() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"ts_3", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"ts_6", (DataType)DataTypes.TIMESTAMP((int)6)), DataTypes.FIELD((String)"ts_9", (DataType)DataTypes.TIMESTAMP((int)9))});
        MessageType messageType = ParquetSchemaConverter.convertToParquetMessageType((String)"converted", (RowType)((RowType)dataType.getLogicalType()));
        MatcherAssert.assertThat((Object)messageType.getColumns().size(), (Matcher)CoreMatchers.is((Object)3));
        String expected = "message converted {\n  optional int64 ts_3 (TIMESTAMP(MILLIS,true));\n  optional int64 ts_6 (TIMESTAMP(MICROS,true));\n  optional int96 ts_9;\n}\n";
        MatcherAssert.assertThat((Object)messageType.toString(), (Matcher)CoreMatchers.is((Object)"message converted {\n  optional int64 ts_3 (TIMESTAMP(MILLIS,true));\n  optional int64 ts_6 (TIMESTAMP(MICROS,true));\n  optional int96 ts_9;\n}\n"));
    }
}

