/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.metadata.FlinkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.util.FlinkClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieFlinkTableServiceClient<T>
extends BaseHoodieTableServiceClient<List<HoodieRecord<T>>, List<WriteStatus>, List<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieFlinkTableServiceClient.class);

    protected HoodieFlinkTableServiceClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, clientConfig, timelineService);
    }

    protected HoodieWriteMetadata<List<WriteStatus>> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieWriteMetadata compactionMetadata = this.createTable(this.config, this.storageConf).compact(this.context, compactionInstantTime);
        this.commitCompaction(compactionInstantTime, (HoodieCommitMetadata)compactionMetadata.getCommitMetadata().get(), Option.empty());
        return compactionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeCompaction(HoodieCommitMetadata metadata, HoodieTable table, String compactionCommitTime) {
        this.context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Collect compaction write status and commit compaction: " + this.config.getTableName());
        List writeStats = metadata.getWriteStats();
        HoodieInstant compactionInstant = table.getInstantGenerator().getCompactionInflightInstant(compactionCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of((Object)compactionInstant), Option.empty());
            this.finalizeWrite(table, compactionCommitTime, writeStats);
            this.writeTableMetadata(table, compactionCommitTime, metadata);
            LOG.info("Committing Compaction {} finished with result {}.", (Object)compactionCommitTime, (Object)metadata);
            CompactHelpers.getInstance().completeInflightCompaction(table, compactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of((Object)compactionInstant));
        }
        WriteMarkersFactory.get((MarkerType)this.config.getMarkersType(), (HoodieTable)table, (String)compactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.compactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.compactionTimer.stop());
            try {
                this.metrics.updateCommitMetrics(TimelineUtils.parseDateFromInstantTime((String)compactionCommitTime).getTime(), durationInMs, metadata, "compaction");
            }
            catch (ParseException e) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + compactionCommitTime, (Throwable)e);
            }
        }
        LOG.info("Compacted successfully on commit " + compactionCommitTime);
    }

    protected void completeClustering(HoodieReplaceCommitMetadata metadata, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, String clusteringCommitTime) {
        this.context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Collect clustering write status and commit clustering");
        HoodieInstant clusteringInstant = (HoodieInstant)ClusteringUtils.getInflightClusteringInstant((String)clusteringCommitTime, (HoodieActiveTimeline)table.getActiveTimeline(), (InstantGenerator)table.getInstantGenerator()).get();
        List writeStats = metadata.getPartitionToWriteStats().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        if (writeStats.stream().mapToLong(HoodieWriteStat::getTotalWriteErrors).sum() > 0L) {
            throw new HoodieClusteringException("Clustering failed to write to files:" + writeStats.stream().filter(s -> s.getTotalWriteErrors() > 0L).map(HoodieWriteStat::getFileId).collect(Collectors.joining(",")));
        }
        try {
            this.txnManager.beginTransaction(Option.of((Object)clusteringInstant), Option.empty());
            this.finalizeWrite(table, clusteringCommitTime, writeStats);
            if (this.isPreCommitRequired()) {
                this.preCommit((HoodieCommitMetadata)metadata);
            }
            this.writeTableMetadata(table, clusteringCommitTime, (HoodieCommitMetadata)metadata);
            LOG.info("Committing Clustering {} finished with result {}.", (Object)clusteringCommitTime, (Object)metadata);
            ClusteringUtils.transitionClusteringOrReplaceInflightToComplete((boolean)false, (HoodieInstant)clusteringInstant, (HoodieReplaceCommitMetadata)metadata, (HoodieActiveTimeline)table.getActiveTimeline());
        }
        catch (HoodieIOException e2) {
            throw new HoodieClusteringException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + clusteringCommitTime, (Throwable)e2);
        }
        finally {
            this.txnManager.endTransaction(Option.of((Object)clusteringInstant));
        }
        WriteMarkersFactory.get((MarkerType)this.config.getMarkersType(), table, (String)clusteringCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.clusteringTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.clusteringTimer.stop());
            try {
                this.metrics.updateCommitMetrics(TimelineUtils.parseDateFromInstantTime((String)clusteringCommitTime).getTime(), durationInMs, (HoodieCommitMetadata)metadata, "clustering");
            }
            catch (ParseException e3) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + clusteringCommitTime, (Throwable)e3);
            }
        }
        LOG.info("Clustering successfully on commit " + clusteringCommitTime);
    }

    public HoodieWriteMetadata<List<WriteStatus>> cluster(String clusteringInstant, boolean shouldComplete) {
        return null;
    }

    protected HoodieWriteMetadata<List<WriteStatus>> convertToOutputMetadata(HoodieWriteMetadata<List<WriteStatus>> writeMetadata) {
        return writeMetadata;
    }

    protected HoodieTable createTable(HoodieWriteConfig config, StorageConfiguration<?> storageConf, boolean skipValidation) {
        return this.createTableAndValidate(config, HoodieFlinkTable::create, skipValidation);
    }

    private HoodieBackedTableMetadataWriter initMetadataWriter(Option<String> latestPendingInstant) {
        return (HoodieBackedTableMetadataWriter)FlinkHoodieBackedTableMetadataWriter.create(HadoopFSUtils.getStorageConf((Configuration)FlinkClientUtil.getHadoopConf()), this.config, HoodieFlinkEngineContext.DEFAULT, latestPendingInstant);
    }

    public void initMetadataTable() {
        HoodieFlinkTable table = (HoodieFlinkTable)this.createTable(this.config, this.storageConf, false);
        if (this.config.isMetadataTableEnabled()) {
            Option latestPendingInstant = table.getActiveTimeline().filterInflightsAndRequested().lastInstant().map(HoodieInstant::requestedTime);
            try {
                this.txnManager.getLockManager().lock();
                try (HoodieBackedTableMetadataWriter metadataWriter = this.initMetadataWriter((Option<String>)latestPendingInstant);){
                    if (metadataWriter.isInitialized()) {
                        metadataWriter.performTableServices(Option.empty());
                    }
                }
            }
            catch (Exception e) {
                throw new HoodieException("Failed to initialize metadata table", (Throwable)e);
            }
            finally {
                this.txnManager.getLockManager().unlock();
            }
            table.deleteMetadataIndexIfNecessary();
        } else {
            table.maybeDeleteMetadataTable();
        }
    }

    protected void handleWriteErrors(List<HoodieWriteStat> writeStats, TableServiceType tableServiceType) {
    }
}

