/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import java.io.Serializable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.types.BooleanValue;

public class HoodieFlinkInternalRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int ARITY = 7;
    private final StringData recordKey;
    private final StringData partitionPath;
    private StringData fileId;
    private StringData instantTime;
    private StringData operationType;
    private final BooleanValue isIndexRecord;
    private final RowData rowData;

    public HoodieFlinkInternalRow(String recordKey, String partitionPath, String operationType, RowData rowData) {
        this(recordKey, partitionPath, "", "", operationType, false, rowData);
    }

    public HoodieFlinkInternalRow(String recordKey, String partitionPath, String fileId, String instantTime) {
        this(recordKey, partitionPath, fileId, instantTime, "", true, null);
    }

    public HoodieFlinkInternalRow(String recordKey, String partitionPath, String fileId, String instantTime, String operationType, boolean isIndexRecord, RowData rowData) {
        this.recordKey = StringData.fromString((String)recordKey);
        this.partitionPath = StringData.fromString((String)partitionPath);
        this.fileId = StringData.fromString((String)fileId);
        this.instantTime = StringData.fromString((String)instantTime);
        this.operationType = StringData.fromString((String)operationType);
        this.isIndexRecord = new BooleanValue(isIndexRecord);
        this.rowData = rowData;
    }

    public String getRecordKey() {
        return String.valueOf(this.recordKey);
    }

    public String getPartitionPath() {
        return String.valueOf(this.partitionPath);
    }

    public void setFileId(String fileId) {
        this.fileId = StringData.fromString((String)fileId);
    }

    public String getFileId() {
        return String.valueOf(this.fileId);
    }

    public void setInstantTime(String instantTime) {
        this.instantTime = StringData.fromString((String)instantTime);
    }

    public String getInstantTime() {
        return String.valueOf(this.instantTime);
    }

    public void setOperationType(String operationType) {
        this.operationType = StringData.fromString((String)operationType);
    }

    public String getOperationType() {
        return String.valueOf(this.operationType);
    }

    public boolean isIndexRecord() {
        return this.isIndexRecord.getValue();
    }

    public RowData getRowData() {
        return this.rowData;
    }

    public HoodieFlinkInternalRow copy(RowDataSerializer rowDataSerializer) {
        return new HoodieFlinkInternalRow(this.recordKey.toString(), this.partitionPath.toString(), this.fileId.toString(), this.instantTime.toString(), this.operationType.toString(), this.isIndexRecord.getValue(), rowDataSerializer.copy(this.rowData));
    }
}

