/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieDeletePartitionPendingTableServiceException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseFlinkCommitActionExecutor;
import org.apache.hudi.table.action.commit.FlinkDeletePartitionCommitActionExecutor;
import org.apache.hudi.table.action.ttl.strategy.HoodiePartitionTTLStrategyFactory;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkPartitionTTLActionExecutor<T>
extends BaseFlinkCommitActionExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkPartitionTTLActionExecutor.class);

    public FlinkPartitionTTLActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime) {
        super(context, null, config, table, instantTime, WriteOperationType.DELETE_PARTITION);
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        HoodieWriteMetadata emptyResult = new HoodieWriteMetadata();
        emptyResult.setPartitionToReplaceFileIds(Collections.emptyMap());
        emptyResult.setWriteStatuses(Collections.emptyList());
        try {
            PartitionTTLStrategy strategy = HoodiePartitionTTLStrategyFactory.createStrategy((HoodieTable)this.table, (TypedProperties)this.config.getProps(), (String)this.instantTime);
            List expiredPartitions = strategy.getExpiredPartitionPaths();
            if (expiredPartitions.isEmpty()) {
                return emptyResult;
            }
            LOG.info("Partition ttl find the following expired partitions to delete:  " + String.join((CharSequence)",", expiredPartitions));
            HoodieWriteConfig autoCommitConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)this.config.getProps()).withAutoCommit(true).build();
            return new FlinkDeletePartitionCommitActionExecutor(this.context, autoCommitConfig, this.table, this.instantTime, expiredPartitions).execute();
        }
        catch (HoodieDeletePartitionPendingTableServiceException deletePartitionPendingTableServiceException) {
            LOG.info("Partition is under table service, do nothing, call delete partition next time.");
            return emptyResult;
        }
        catch (IOException e) {
            throw new HoodieIOException("Error executing hoodie partition ttl: ", e);
        }
    }
}

