/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsInference;
import org.apache.hudi.util.ClientIds;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestOptionsInference {
    @TempDir
    File tempFile;

    @Test
    void testSetupClientId() throws Exception {
        Configuration conf = this.getConf();
        conf.setString(FlinkOptions.WRITE_CLIENT_ID, "2");
        OptionsInference.setupClientId((Configuration)conf);
        MatcherAssert.assertThat((String)"Explicit client id has higher priority", (Object)conf.getString(FlinkOptions.WRITE_CLIENT_ID), (Matcher)CoreMatchers.is((Object)"2"));
        for (int i = 0; i < 3; ++i) {
            conf = this.getConf();
            try (ClientIds clientIds = ClientIds.builder().conf(conf).build();){
                OptionsInference.setupClientId((Configuration)conf);
                String expectedId = i == 0 ? "" : i + "";
                MatcherAssert.assertThat((String)("The client id should auto inc to " + expectedId), (Object)conf.getString(FlinkOptions.WRITE_CLIENT_ID), (Matcher)CoreMatchers.is((Object)expectedId));
                continue;
            }
        }
        Thread.sleep(1000L);
        conf = this.getConf();
        try (ClientIds clientIds = ClientIds.builder().conf(conf).heartbeatIntervalInMs(10L).numTolerableHeartbeatMisses(1).build();){
            String nextId = clientIds.nextId(conf);
            MatcherAssert.assertThat((String)"The inactive client id should be reused", (Object)nextId, (Matcher)CoreMatchers.is((Object)""));
        }
    }

    private Configuration getConf() {
        Configuration conf = new Configuration();
        conf.setString(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
        conf.setString(FlinkOptions.PATH, this.tempFile.getAbsolutePath());
        return conf;
    }
}

