/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.index.HoodieIndex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestOptionsResolver {
    @TempDir
    File tempFile;

    @Test
    void testGetIndexType() {
        Configuration conf = this.getConf();
        conf.setString(FlinkOptions.INDEX_TYPE, "BLOOM");
        Assertions.assertEquals((Object)HoodieIndex.IndexType.BLOOM, (Object)OptionsResolver.getIndexType((Configuration)conf));
        conf.setString(FlinkOptions.INDEX_TYPE, "bloom");
        Assertions.assertEquals((Object)HoodieIndex.IndexType.BLOOM, (Object)OptionsResolver.getIndexType((Configuration)conf));
    }

    @Test
    void testIsLazyFailedWritesCleanPolicy() {
        Configuration conf = new Configuration();
        conf.set(FlinkOptions.CLEAN_ASYNC_ENABLED, (Object)true);
        conf.setString(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.NEVER.name());
        Assertions.assertFalse((boolean)OptionsResolver.isLazyFailedWritesCleanPolicy((Configuration)conf));
        if (!HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.getAlternatives().isEmpty()) {
            conf = new Configuration();
            conf.set(FlinkOptions.CLEAN_ASYNC_ENABLED, (Object)true);
            conf.setString((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.getAlternatives().get(0), HoodieFailedWritesCleaningPolicy.LAZY.name());
            Assertions.assertTrue((boolean)OptionsResolver.isLazyFailedWritesCleanPolicy((Configuration)conf));
        }
    }

    private Configuration getConf() {
        Configuration conf = new Configuration();
        conf.setString(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
        conf.setString(FlinkOptions.PATH, this.tempFile.getAbsolutePath());
        return conf;
    }
}

