/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink;

import org.apache.flink.configuration.Configuration;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.config.HoodieTTLConfig;
import org.apache.hudi.sink.utils.TestWriteBase;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.ttl.strategy.KeepByTimeStrategy;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWriterWithPartitionTTl
extends TestWriteBase {
    @Override
    protected void setUp(Configuration conf) {
        conf.setBoolean(HoodieTTLConfig.INLINE_PARTITION_TTL.key(), true);
        conf.setString(HoodieTTLConfig.DAYS_RETAIN.key(), "1");
        conf.setString(HoodieTTLConfig.PARTITION_TTL_STRATEGY_CLASS_NAME.key(), FlinkPartitionTTLTestStrategy.class.getName());
    }

    @Test
    public void testFlinkWriterWithPartitionTTL() throws Exception {
        this.preparePipeline(this.conf).consume(TestData.DATA_SET_PART1).assertEmptyDataFiles().checkpoint(1L).assertNextEvent().checkpointComplete(1L).end();
        this.preparePipeline(this.conf).consume(TestData.DATA_SET_PART2).checkpoint(2L).assertNextEvent().checkpointComplete(2L).end();
        HoodieActiveTimeline timeline = StreamerUtil.createMetaClient((Configuration)this.conf).getActiveTimeline();
        Assertions.assertTrue((timeline.getCompletedReplaceTimeline().getInstants().size() > 0 ? 1 : 0) != 0);
        HoodieInstant replaceCommit = (HoodieInstant)timeline.getCompletedReplaceTimeline().getInstants().get(0);
        HoodieReplaceCommitMetadata commitMetadata = timeline.readReplaceCommitMetadataToAvro(replaceCommit);
        Assertions.assertTrue((boolean)commitMetadata.getPartitionToReplaceFileIds().containsKey("par1"));
    }

    public static class FlinkPartitionTTLTestStrategy
    extends KeepByTimeStrategy {
        public FlinkPartitionTTLTestStrategy(HoodieTable hoodieTable, String instantTime) {
            super(hoodieTable, instantTime);
        }

        protected boolean isPartitionExpired(String referenceTime) {
            String expiredTime = HoodieInstantTimeGenerator.instantTimePlusMillis((String)referenceTime, (long)(this.ttlInMilis / 24L / 3600L));
            return HoodieInstantTimeGenerator.fixInstantTimeCompatibility((String)this.instantTime).compareTo(expiredTime) > 0;
        }
    }
}

