/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bulk;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.sink.bulk.BulkInsertWriterHelper;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.FlinkTables;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestBulkInsertWriteHelper {
    protected Configuration conf;
    @TempDir
    File tempFile;

    @BeforeEach
    public void before() throws IOException {
        this.conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        StreamerUtil.initTableIfNotExists((Configuration)this.conf);
    }

    @Test
    void testWrite() throws Exception {
        HoodieFlinkTable table = FlinkTables.createTable((Configuration)this.conf);
        String instant = table.getMetaClient().createNewInstantTime();
        RowType rowType = TestConfigurations.ROW_TYPE;
        BulkInsertWriterHelper writerHelper = new BulkInsertWriterHelper(this.conf, (HoodieTable)table, table.getConfig(), instant, 1, 1L, 0L, rowType, false);
        for (RowData row : TestData.DATA_SET_INSERT) {
            writerHelper.write(row);
        }
        List writeStatusList = writerHelper.getWriteStatuses(1);
        this.assertWriteStatus(writeStatusList);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("par1", "[id1,par1,id1,Danny,23,1,par1, id2,par1,id2,Stephen,33,2,par1]");
        expected.put("par2", "[id3,par2,id3,Julian,53,3,par2, id4,par2,id4,Fabian,31,4,par2]");
        expected.put("par3", "[id5,par3,id5,Sophia,18,5,par3, id6,par3,id6,Emma,20,6,par3]");
        expected.put("par4", "[id7,par4,id7,Bob,44,7,par4, id8,par4,id8,Han,56,8,par4]");
        TestData.checkWrittenData(this.tempFile, expected);
        RowType rowType2 = BulkInsertWriterHelper.addMetadataFields((RowType)rowType, (boolean)false);
        BulkInsertWriterHelper writerHelper2 = new BulkInsertWriterHelper(this.conf, (HoodieTable)table, table.getConfig(), instant, 1, 1L, 0L, rowType2, true);
        for (RowData row : TestBulkInsertWriteHelper.rowsWithMetadata(instant, TestData.DATA_SET_INSERT)) {
            writerHelper.write(row);
        }
        List writeStatusList2 = writerHelper.getWriteStatuses(1);
        this.assertWriteStatus(writeStatusList2);
        String expectRows = "[" + instant + ", " + instant + "]";
        HashMap<String, String> expected2 = new HashMap<String, String>();
        expected2.put("par1", expectRows);
        expected2.put("par2", expectRows);
        expected2.put("par3", expectRows);
        expected2.put("par4", expectRows);
        TestData.checkWrittenData(this.tempFile, expected2, 4, TestBulkInsertWriteHelper::filterCommitTime);
    }

    private void assertWriteStatus(List<WriteStatus> writeStatusList) {
        String partitions = writeStatusList.stream().map(writeStatus -> StringUtils.nullToEmpty((String)writeStatus.getStat().getPartitionPath())).sorted().collect(Collectors.joining(","));
        MatcherAssert.assertThat((Object)partitions, (Matcher)CoreMatchers.is((Object)"par1,par2,par3,par4"));
        List files = writeStatusList.stream().map(writeStatus -> writeStatus.getStat().getPath()).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)files.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    private static List<RowData> rowsWithMetadata(String instantTime, List<RowData> rows) {
        ArrayList<RowData> rowsWithMetadata = new ArrayList<RowData>();
        int seqNum = 0;
        for (RowData row : rows) {
            GenericRowData rebuilt = new GenericRowData(row.getArity() + 5);
            rebuilt.setField(0, (Object)StringData.fromString((String)instantTime));
            rebuilt.setField(1, (Object)seqNum++);
            rebuilt.setField(2, (Object)row.getString(0));
            rebuilt.setField(3, (Object)row.getString(4));
            rebuilt.setField(4, (Object)StringData.fromString((String)("f" + seqNum)));
        }
        return rowsWithMetadata;
    }

    private static String filterCommitTime(GenericRecord genericRecord) {
        return genericRecord.get("_hoodie_commit_time").toString();
    }
}

