/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.cluster;

import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sink.clustering.ClusteringCommitEvent;
import org.apache.hudi.sink.clustering.ClusteringCommitSink;

public class ClusteringCommitTestSink
extends ClusteringCommitSink {
    public ClusteringCommitTestSink(Configuration conf) {
        super(conf);
    }

    public void invoke(ClusteringCommitEvent event, SinkFunction.Context context) throws Exception {
        super.invoke(event, context);
        List instants = this.writeClient.getHoodieTable().getMetaClient().getActiveTimeline().getInstants();
        boolean committed = instants.stream().anyMatch(i -> i.requestedTime().equals(event.getInstant()) && i.isCompleted());
        if (committed && this.getRuntimeContext().getAttemptNumber() == 0) {
            throw new HoodieException("Fail first attempt to simulate failover in test.");
        }
    }
}

