/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.sink.compact.FlinkCompactionConfig;
import org.apache.hudi.sink.compact.strategy.CompactionPlanStrategies;
import org.apache.hudi.sink.compact.strategy.CompactionPlanStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCompactionPlanStrategy {
    private HoodieTimeline timeline;
    private HoodieTimeline emptyTimeline;
    private HoodieTimeline allCompleteTimeline;
    private static final HoodieInstant INSTANT_001 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "001");
    private static final HoodieInstant INSTANT_002 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", "002");
    private static final HoodieInstant INSTANT_003 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", "003");
    private static final HoodieInstant INSTANT_004 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", "004");
    private static final HoodieInstant INSTANT_005 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "compaction", "005");
    private static final HoodieInstant INSTANT_006 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", "006");

    @BeforeEach
    public void beforeEach() {
        this.timeline = new MockHoodieActiveTimeline(INSTANT_001, INSTANT_002, INSTANT_003, INSTANT_004, INSTANT_005, INSTANT_006);
        this.emptyTimeline = new MockHoodieActiveTimeline(new HoodieInstant[0]);
        this.allCompleteTimeline = new MockHoodieActiveTimeline(INSTANT_001, INSTANT_005);
    }

    @Test
    void testSingleCompactionPlanSelectStrategy() {
        HoodieTimeline pendingCompactionTimeline = this.timeline.filterPendingCompactionTimeline();
        FlinkCompactionConfig compactionConfig = new FlinkCompactionConfig();
        CompactionPlanStrategy strategy = CompactionPlanStrategies.getStrategy((FlinkCompactionConfig)compactionConfig);
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_002}, strategy.select(pendingCompactionTimeline));
        compactionConfig.compactionSeq = "LIFO";
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_006}, strategy.select(pendingCompactionTimeline));
        HoodieTimeline emptyPendingCompactionTimeline = this.emptyTimeline.filterPendingCompactionTimeline();
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(emptyPendingCompactionTimeline));
        HoodieTimeline allCompleteCompactionTimeline = this.allCompleteTimeline.filterPendingCompactionTimeline();
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(allCompleteCompactionTimeline));
    }

    @Test
    void testMultiCompactionPlanSelectStrategy() {
        HoodieTimeline pendingCompactionTimeline = this.timeline.filterPendingCompactionTimeline();
        FlinkCompactionConfig compactionConfig = new FlinkCompactionConfig();
        compactionConfig.maxNumCompactionPlans = 2;
        CompactionPlanStrategy strategy = CompactionPlanStrategies.getStrategy((FlinkCompactionConfig)compactionConfig);
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_002, INSTANT_003}, strategy.select(pendingCompactionTimeline));
        compactionConfig.compactionSeq = "LIFO";
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_006, INSTANT_004}, strategy.select(pendingCompactionTimeline));
        HoodieTimeline emptyPendingCompactionTimeline = this.emptyTimeline.filterPendingCompactionTimeline();
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(emptyPendingCompactionTimeline));
        HoodieTimeline allCompleteCompactionTimeline = this.allCompleteTimeline.filterPendingCompactionTimeline();
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(allCompleteCompactionTimeline));
    }

    @Test
    void testAllPendingCompactionPlanSelectStrategy() {
        HoodieTimeline pendingCompactionTimeline = this.timeline.filterPendingCompactionTimeline();
        FlinkCompactionConfig compactionConfig = new FlinkCompactionConfig();
        compactionConfig.compactionPlanSelectStrategy = "all";
        CompactionPlanStrategy strategy = CompactionPlanStrategies.getStrategy((FlinkCompactionConfig)compactionConfig);
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_002, INSTANT_003, INSTANT_004, INSTANT_006}, strategy.select(pendingCompactionTimeline));
        HoodieTimeline emptyPendingCompactionTimeline = this.emptyTimeline.filterPendingCompactionTimeline();
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(emptyPendingCompactionTimeline));
        HoodieTimeline allCompleteCompactionTimeline = this.allCompleteTimeline.filterPendingCompactionTimeline();
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(allCompleteCompactionTimeline));
    }

    @Test
    void testInstantCompactionPlanSelectStrategy() {
        HoodieTimeline pendingCompactionTimeline = this.timeline.filterPendingCompactionTimeline();
        FlinkCompactionConfig compactionConfig = new FlinkCompactionConfig();
        compactionConfig.compactionPlanSelectStrategy = "instants";
        CompactionPlanStrategy strategy = CompactionPlanStrategies.getStrategy((FlinkCompactionConfig)compactionConfig);
        compactionConfig.compactionPlanInstant = "004";
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_004}, strategy.select(pendingCompactionTimeline));
        compactionConfig.compactionPlanInstant = "002,003";
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_002, INSTANT_003}, strategy.select(pendingCompactionTimeline));
        compactionConfig.compactionPlanInstant = "002,005";
        this.assertHoodieInstantsEquals(new HoodieInstant[]{INSTANT_002}, strategy.select(pendingCompactionTimeline));
        compactionConfig.compactionPlanInstant = "005";
        this.assertHoodieInstantsEquals(new HoodieInstant[0], strategy.select(pendingCompactionTimeline));
    }

    private void assertHoodieInstantsEquals(HoodieInstant[] expected, List<HoodieInstant> actual) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int index = 0; index < expected.length; ++index) {
            this.assertHoodieInstantEquals(expected[index], actual.get(index));
        }
    }

    private void assertHoodieInstantEquals(HoodieInstant expected, HoodieInstant actual) {
        Assertions.assertEquals((Object)expected.getState(), (Object)actual.getState());
        Assertions.assertEquals((Object)expected.getAction(), (Object)actual.getAction());
        Assertions.assertEquals((Object)expected.requestedTime(), (Object)actual.requestedTime());
    }

    private static final class MockHoodieActiveTimeline
    extends ActiveTimelineV2 {
        public MockHoodieActiveTimeline(HoodieInstant ... instants) {
            this.setInstants(Arrays.asList(instants));
        }
    }
}

