/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.meta;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.sink.meta.CkpMetadata;
import org.apache.hudi.sink.meta.CkpMetadataFactory;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestCkpMetadata {
    @TempDir
    File tempFile;
    protected Configuration conf;
    protected HoodieFlinkWriteClient writeClient;

    @BeforeEach
    public void beforeEach() throws Exception {
        this.setup();
    }

    protected void setup() throws IOException {
        String basePath = this.tempFile.getAbsolutePath();
        this.conf = TestConfigurations.getDefaultConf(basePath);
        StreamerUtil.initTableIfNotExists((Configuration)this.conf);
        this.writeClient = FlinkWriteClients.createWriteClient((Configuration)this.conf);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "1"})
    void testWriteAndReadMessage(String uniqueId) {
        CkpMetadata metadata = this.getCkpMetadata(uniqueId);
        IntStream.range(0, 3).forEach(i -> metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)metadata.lastPendingInstant(), (Matcher)CoreMatchers.is((Object)"2"));
        metadata.commitInstant("2");
        MatcherAssert.assertThat((Object)metadata.lastPendingInstant(), (Matcher)CoreMatchers.equalTo(null));
        IntStream.range(3, 6).forEach(i -> metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        metadata.commitInstant("6");
        metadata.abortInstant("7");
        MatcherAssert.assertThat((Object)metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    void testBootstrap() throws Exception {
        CkpMetadata metadata = this.getCkpMetadata("");
        IntStream.range(0, 4).forEach(i -> metadata.startInstant(i + ""));
        MatcherAssert.assertThat((String)"The first instant should be removed from the instant cache", (Object)metadata.getInstantCache(), (Matcher)CoreMatchers.is(Arrays.asList("1", "2", "3")));
        CkpMetadata metadata1 = this.getCkpMetadata("");
        metadata1.bootstrap();
        Assertions.assertNull((Object)metadata1.getInstantCache(), (String)"The instant cache should be recovered from bootstrap");
        metadata1.startInstant("4");
        MatcherAssert.assertThat((String)"The first instant should be removed from the instant cache", (Object)metadata1.getInstantCache(), (Matcher)CoreMatchers.is(Collections.singletonList("4")));
    }

    protected CkpMetadata getCkpMetadata(String uniqueId) {
        this.conf.set(FlinkOptions.WRITE_CLIENT_ID, (Object)uniqueId);
        return CkpMetadataFactory.getCkpMetadata((HoodieWriteConfig)this.writeClient.getConfig(), (Configuration)this.conf);
    }

    @AfterEach
    public void cleanup() {
        if (this.writeClient != null) {
            this.writeClient.close();
            this.writeClient = null;
        }
    }
}

