/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.hudi.sink.utils.keyedstate.MockKeyContext;
import org.apache.hudi.sink.utils.keyedstate.MockKeyedListState;
import org.apache.hudi.sink.utils.keyedstate.MockKeyedMapState;
import org.apache.hudi.sink.utils.keyedstate.MockKeyedValueState;

public class MockKeyedStateStore
implements KeyedStateStore {
    private final MockKeyContext keyContext = new MockKeyContext();
    private Map<String, MockKeyedValueState> keyedValueStateMap = new HashMap<String, MockKeyedValueState>();
    private Map<String, MockKeyedListState> keyedListStateMap = new HashMap<String, MockKeyedListState>();
    private Map<String, MockKeyedMapState> keyedMapStateMap = new HashMap<String, MockKeyedMapState>();
    private final Map<Long, Map<String, MockKeyedValueState>> historyValueStateMap = new HashMap<Long, Map<String, MockKeyedValueState>>();
    private final Map<Long, Map<String, MockKeyedListState>> historyListStateMap = new HashMap<Long, Map<String, MockKeyedListState>>();
    private final Map<Long, Map<String, MockKeyedMapState>> historyMapStateMap = new HashMap<Long, Map<String, MockKeyedMapState>>();
    private Map<String, MockKeyedValueState> lastSuccessValueStateMap = new HashMap<String, MockKeyedValueState>();
    private Map<String, MockKeyedListState> lastSuccessListStateMap = new HashMap<String, MockKeyedListState>();
    private Map<String, MockKeyedMapState> lastSuccessMapStateMap = new HashMap<String, MockKeyedMapState>();

    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        String name = stateProperties.getName();
        this.keyedValueStateMap.putIfAbsent(name, new MockKeyedValueState(this.keyContext));
        return this.keyedValueStateMap.get(name);
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        String name = stateProperties.getName();
        this.keyedListStateMap.putIfAbsent(name, new MockKeyedListState(this.keyContext));
        return this.keyedListStateMap.get(name);
    }

    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        throw new UnsupportedOperationException("getReducingState is not supported yet");
    }

    public <I, A, O> AggregatingState<I, O> getAggregatingState(AggregatingStateDescriptor<I, A, O> stateProperties) {
        throw new UnsupportedOperationException("getAggregatingState is not supported yet");
    }

    public <K, V> MapState<K, V> getMapState(MapStateDescriptor<K, V> stateProperties) {
        String name = stateProperties.getName();
        this.keyedMapStateMap.putIfAbsent(name, new MockKeyedMapState(this.keyContext));
        return this.keyedMapStateMap.get(name);
    }

    public void setCurrentKey(Object currentKey) {
        Objects.requireNonNull(currentKey, "currentKey is null");
        this.keyContext.setCurrentKey(currentKey);
    }

    public void checkpointBegin(long checkpointId) throws Exception {
        this.historyValueStateMap.put(checkpointId, this.copyKeyedValueStates(this.keyedValueStateMap));
        this.historyListStateMap.put(checkpointId, this.copyKeyedListStates(this.keyedListStateMap));
        this.historyMapStateMap.put(checkpointId, this.copyKeyedMapStates(this.keyedMapStateMap));
    }

    public void checkpointSuccess(long checkpointId) {
        this.lastSuccessValueStateMap = this.historyValueStateMap.get(checkpointId);
        this.lastSuccessListStateMap = this.historyListStateMap.get(checkpointId);
        this.lastSuccessMapStateMap = this.historyMapStateMap.get(checkpointId);
    }

    public void rollBackToLastSuccessCheckpoint() {
        this.keyedValueStateMap = this.copyKeyedValueStates(this.lastSuccessValueStateMap);
        this.keyedListStateMap = this.copyKeyedListStates(this.lastSuccessListStateMap);
        this.keyedMapStateMap = this.copyKeyedMapStates(this.lastSuccessMapStateMap);
    }

    private Map<String, MockKeyedValueState> copyKeyedValueStates(Map<String, MockKeyedValueState> keyedValueStateMap) {
        return Collections.unmodifiableMap(keyedValueStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (MockKeyedValueState)((MockKeyedValueState)entry.getValue()).clone())));
    }

    private Map<String, MockKeyedListState> copyKeyedListStates(Map<String, MockKeyedListState> keyedListStateMap) {
        return Collections.unmodifiableMap(keyedListStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (MockKeyedListState)((MockKeyedListState)entry.getValue()).clone())));
    }

    private Map<String, MockKeyedMapState> copyKeyedMapStates(Map<String, MockKeyedMapState> keyedMapStateMap) {
        return Collections.unmodifiableMap(keyedMapStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (MockKeyedMapState)((MockKeyedMapState)entry.getValue()).clone())));
    }
}

