/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.OptionalLong;
import org.apache.flink.runtime.state.KeyGroupStatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.hudi.sink.utils.MockKeyedStateStore;
import org.apache.hudi.sink.utils.MockOperatorStateStore;
import org.junit.jupiter.api.Assertions;

public class MockStateInitializationContext
implements StateInitializationContext {
    private final MockOperatorStateStore operatorStateStore = new MockOperatorStateStore();
    private final MockKeyedStateStore keyedStateStore = new MockKeyedStateStore();
    private long lastCheckpointId = -1L;

    public MockOperatorStateStore getOperatorStateStore() {
        return this.operatorStateStore;
    }

    public MockKeyedStateStore getKeyedStateStore() {
        return this.keyedStateStore;
    }

    public Iterable<StatePartitionStreamProvider> getRawOperatorStateInputs() {
        return null;
    }

    public Iterable<KeyGroupStatePartitionStreamProvider> getRawKeyedStateInputs() {
        return null;
    }

    public boolean isRestored() {
        return this.getRestoredCheckpointId().isPresent();
    }

    public OptionalLong getRestoredCheckpointId() {
        return this.lastCheckpointId >= 0L ? OptionalLong.of(this.lastCheckpointId) : OptionalLong.empty();
    }

    public void checkpointBegin(long checkpointId) throws Exception {
        Assertions.assertTrue((checkpointId >= 0L ? 1 : 0) != 0, (String)("Checkpoint ID must be non-negative, but was: " + checkpointId));
        this.getOperatorStateStore().checkpointBegin(checkpointId);
        this.getKeyedStateStore().checkpointBegin(checkpointId);
        this.lastCheckpointId = checkpointId;
    }

    public void checkpointSuccess(long checkpointId) {
        Assertions.assertTrue((checkpointId >= 0L ? 1 : 0) != 0, (String)("Checkpoint ID must be non-negative, but was: " + checkpointId));
        this.getOperatorStateStore().checkpointSuccess(checkpointId);
        this.getKeyedStateStore().checkpointSuccess(checkpointId);
        this.lastCheckpointId = checkpointId;
    }
}

