/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils.keyedstate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.streaming.api.functions.sink.filesystem.TestUtils;
import org.apache.hudi.sink.utils.keyedstate.MockKeyContext;

public class MockKeyedListState<T>
implements ListState<T>,
Cloneable {
    private MockKeyContext keyContext;
    private Map<Object, TestUtils.MockListState<T>> mockListStateMap;

    public MockKeyedListState(MockKeyContext keyContext) {
        Objects.requireNonNull(keyContext, "keyContext is null");
        this.keyContext = keyContext;
    }

    public void update(List<T> values) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        TestUtils.MockListState listState = this.mockListStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new TestUtils.MockListState());
        listState.update(values);
    }

    public void addAll(List<T> values) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        TestUtils.MockListState listState = this.mockListStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new TestUtils.MockListState());
        listState.addAll(values);
    }

    public Iterable<T> get() throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        TestUtils.MockListState listState = this.mockListStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new TestUtils.MockListState());
        return listState.get();
    }

    public void add(T value) throws Exception {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        TestUtils.MockListState listState = this.mockListStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new TestUtils.MockListState());
        listState.add(value);
    }

    public void clear() {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        TestUtils.MockListState listState = this.mockListStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new TestUtils.MockListState());
        listState.clear();
    }

    public Object clone() {
        try {
            MockKeyedListState copy = (MockKeyedListState)super.clone();
            MockKeyContext newKeyContext = new MockKeyContext();
            newKeyContext.setCurrentKey(this.keyContext.getCurrentKey());
            copy.keyContext = newKeyContext;
            copy.mockListStateMap = this.mockListStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                TestUtils.MockListState oldListState = (TestUtils.MockListState)entry.getValue();
                TestUtils.MockListState newListState = new TestUtils.MockListState();
                newListState.addAll(oldListState.getBackingList());
                return newListState;
            }));
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

