/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils.keyedstate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.state.ValueState;
import org.apache.hudi.sink.utils.MockValueState;
import org.apache.hudi.sink.utils.keyedstate.MockKeyContext;

public class MockKeyedValueState<V>
implements ValueState<V>,
Cloneable {
    private MockKeyContext keyContext;
    private Map<Object, MockValueState<V>> keyValueStateMap;

    public MockKeyedValueState(MockKeyContext keyContext) {
        Objects.requireNonNull(keyContext, "keyContext is null");
        this.keyContext = keyContext;
        this.keyValueStateMap = new HashMap<Object, MockValueState<V>>();
    }

    public V value() throws IOException {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockValueState valueState = this.keyValueStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockValueState());
        return valueState.value();
    }

    public void update(V value) throws IOException {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        MockValueState valueState = this.keyValueStateMap.computeIfAbsent(this.keyContext.getCurrentKey(), k -> new MockValueState());
        valueState.update(value);
    }

    public void clear() {
        Objects.requireNonNull(this.keyContext.getCurrentKey(), "currentKey is null");
        this.keyValueStateMap.remove(this.keyContext.getCurrentKey());
    }

    public Object clone() {
        try {
            MockKeyedValueState copy = (MockKeyedValueState)super.clone();
            MockKeyContext newKeyContext = new MockKeyContext();
            newKeyContext.setCurrentKey(this.keyContext.getCurrentKey());
            copy.keyContext = newKeyContext;
            copy.keyValueStateMap = this.keyValueStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                MockValueState oldValueState = (MockValueState)entry.getValue();
                MockValueState newValueState = new MockValueState();
                newValueState.update(oldValueState.value());
                return newValueState;
            }));
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

