/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.prune;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.source.prune.ColumnStatsProbe;
import org.apache.hudi.source.stats.ColumnStats;
import org.apache.hudi.utils.TestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestColumnStatsProbe {
    TestColumnStatsProbe() {
    }

    @ParameterizedTest
    @MethodSource(value={"testTypes"})
    void testConvertColumnStats(DataType dataType, Object minValue, Object maxValue) {
        DataType rowDataType = this.getDataRowDataType(dataType);
        DataType indexRowDataType = this.getIndexRowDataType(dataType);
        Map stats1 = ColumnStatsProbe.convertColumnStats((RowData)this.getIndexRow(indexRowDataType, minValue, maxValue), (RowType.RowField[])this.getDataFields(rowDataType));
        Assertions.assertEquals((Object)minValue, (Object)((ColumnStats)stats1.get("field")).getMinVal());
        Assertions.assertEquals((Object)maxValue, (Object)((ColumnStats)stats1.get("field")).getMaxVal());
    }

    static Stream<Arguments> testTypes() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{DataTypes.INT(), 1, 5}), Arguments.arguments((Object[])new Object[]{DataTypes.BIGINT(), 3L, 4L}));
    }

    private DataType getIndexRowDataType(DataType dataType) {
        return (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"file_name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"value_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"field_min", (DataType)dataType), DataTypes.FIELD((String)"field_max", (DataType)dataType), DataTypes.FIELD((String)"field_null_cnt", (DataType)DataTypes.BIGINT())}).notNull();
    }

    private RowData getIndexRow(DataType indexRowDataType, Object minValue, Object maxValue) {
        return TestData.insertRow((RowType)indexRowDataType.getLogicalType(), new Object[]{StringData.fromString((String)"f1"), 10L, minValue, maxValue, 2L});
    }

    private DataType getDataRowDataType(DataType dataType) {
        return (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field", (DataType)dataType)}).notNull();
    }

    private RowType.RowField[] getDataFields(DataType rowDataType) {
        return new RowType.RowField[]{(RowType.RowField)((RowType)rowDataType.getLogicalType()).getFields().get(0)};
    }
}

