/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.sink.partitioner.profile.WriteProfiles;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.HoodieCatalog;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieCatalog {
    private static final String TEST_DEFAULT_DATABASE = "test_db";
    private static final String NONE_EXIST_DATABASE = "none_exist_database";
    private static final List<Column> CREATE_COLUMNS = Arrays.asList(Column.physical((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), Column.physical((String)"name", (DataType)DataTypes.VARCHAR((int)20)), Column.physical((String)"age", (DataType)DataTypes.INT()), Column.physical((String)"tss", (DataType)DataTypes.TIMESTAMP((int)3)), Column.physical((String)"partition", (DataType)DataTypes.VARCHAR((int)10)));
    private static final UniqueConstraint CONSTRAINTS = UniqueConstraint.primaryKey((String)"uuid", Arrays.asList("uuid"));
    private static final ResolvedSchema CREATE_TABLE_SCHEMA = new ResolvedSchema(CREATE_COLUMNS, Collections.emptyList(), CONSTRAINTS);
    private static final UniqueConstraint MULTI_KEY_CONSTRAINTS = UniqueConstraint.primaryKey((String)"uuid", Arrays.asList("uuid", "name"));
    private static final ResolvedSchema CREATE_MULTI_KEY_TABLE_SCHEMA = new ResolvedSchema(CREATE_COLUMNS, Collections.emptyList(), MULTI_KEY_CONSTRAINTS);
    private static final List<Column> EXPECTED_TABLE_COLUMNS = CREATE_COLUMNS.stream().map(col -> {
        if (col.getDataType().getLogicalType().getTypeRoot().equals((Object)LogicalTypeRoot.VARCHAR)) {
            DataType dataType = DataTypes.STRING();
            if ("uuid".equals(col.getName())) {
                dataType = (DataType)dataType.notNull();
            }
            return Column.physical((String)col.getName(), (DataType)dataType);
        }
        return col;
    }).collect(Collectors.toList());
    private static final ResolvedSchema EXPECTED_TABLE_SCHEMA = new ResolvedSchema(EXPECTED_TABLE_COLUMNS, Collections.emptyList(), CONSTRAINTS);
    private static final Map<String, String> EXPECTED_OPTIONS = new HashMap<String, String>();
    private static final ResolvedCatalogTable EXPECTED_CATALOG_TABLE;
    private TableEnvironment streamTableEnv;
    private String catalogPathStr;
    private HoodieCatalog catalog;
    @TempDir
    File tempFile;

    @BeforeEach
    void beforeEach() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().build();
        this.streamTableEnv = TableEnvironmentImpl.create((EnvironmentSettings)settings);
        this.streamTableEnv.getConfig().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, 2);
        try {
            FileSystem fs = FileSystem.get((org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)new Configuration()));
            fs.mkdirs(new org.apache.hadoop.fs.Path(this.tempFile.getPath()));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to create tempFile dir.", e);
        }
        this.catalog = new HoodieCatalog("hudi", Configuration.fromMap(this.getDefaultCatalogOption()));
        this.catalog.open();
    }

    Map<String, String> getDefaultCatalogOption() {
        HashMap<String, String> catalogOptions = new HashMap<String, String>();
        Assertions.assertThrows(ValidationException.class, () -> {
            this.catalog = new HoodieCatalog("hudi", Configuration.fromMap((Map)catalogOptions));
        });
        this.catalogPathStr = this.tempFile.getAbsolutePath();
        catalogOptions.put(CatalogOptions.CATALOG_PATH.key(), this.catalogPathStr);
        catalogOptions.put(CatalogOptions.DEFAULT_DATABASE.key(), TEST_DEFAULT_DATABASE);
        return catalogOptions;
    }

    @AfterEach
    void afterEach() {
        if (this.catalog != null) {
            this.catalog.close();
        }
    }

    @Test
    public void testListDatabases() {
        List actual = this.catalog.listDatabases();
        Assertions.assertTrue((boolean)actual.contains(TEST_DEFAULT_DATABASE));
        Assertions.assertFalse((boolean)actual.contains(NONE_EXIST_DATABASE));
    }

    @Test
    public void testDatabaseExists() {
        Assertions.assertTrue((boolean)this.catalog.databaseExists(TEST_DEFAULT_DATABASE));
        Assertions.assertFalse((boolean)this.catalog.databaseExists(NONE_EXIST_DATABASE));
    }

    @Test
    public void testCreateAndDropDatabase() throws Exception {
        CatalogDatabaseImpl expected = new CatalogDatabaseImpl(Collections.emptyMap(), null);
        this.catalog.createDatabase("db1", (CatalogDatabase)expected, true);
        CatalogDatabase actual = this.catalog.getDatabase("db1");
        Assertions.assertTrue((boolean)this.catalog.listDatabases().contains("db1"));
        Assertions.assertEquals((Object)expected.getProperties(), (Object)actual.getProperties());
        Assertions.assertThrows(DatabaseAlreadyExistException.class, () -> this.lambda$testCreateAndDropDatabase$2((CatalogDatabase)expected));
        this.catalog.dropDatabase("db1", true);
        Assertions.assertFalse((boolean)this.catalog.listDatabases().contains("db1"));
        Assertions.assertThrows(DatabaseNotExistException.class, () -> this.catalog.dropDatabase(NONE_EXIST_DATABASE, false));
    }

    @Test
    public void testCreateDatabaseWithOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("k1", "v1");
        options.put("k2", "v2");
        Assertions.assertThrows(CatalogException.class, () -> this.catalog.createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(options, null), true));
    }

    @Test
    public void testCreateTable() throws Exception {
        ObjectPath tablePath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb1");
        this.catalog.createTable(tablePath, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true);
        Assertions.assertTrue((boolean)this.catalog.tableExists(tablePath));
        HoodieTableConfig tableConfig = (HoodieTableConfig)StreamerUtil.getTableConfig((String)((String)this.catalog.getTable(tablePath).getOptions().get(FlinkOptions.PATH.key())), (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)new Configuration())).get();
        Option tableCreateSchema = tableConfig.getTableCreateSchema();
        Assertions.assertTrue((boolean)tableCreateSchema.isPresent(), (String)"Table should have been created");
        MatcherAssert.assertThat((Object)((org.apache.avro.Schema)tableCreateSchema.get()).getFullName(), (Matcher)CoreMatchers.is((Object)"hoodie.tb1.tb1_record"));
        Assertions.assertThrows(TableAlreadyExistException.class, () -> this.catalog.createTable(tablePath, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, false));
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)this.catalog.inferTablePath(this.catalogPathStr, tablePath));
        String keyGeneratorClassName = metaClient.getTableConfig().getKeyGeneratorClassName();
        Assertions.assertEquals((Object)keyGeneratorClassName, (Object)SimpleAvroKeyGenerator.class.getName());
        ObjectPath singleKeyMultiplePartitionPath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb_skmp" + System.currentTimeMillis());
        ResolvedCatalogTable singleKeyMultiplePartitionTable = new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(CREATE_TABLE_SCHEMA).build(), (String)"test", (List)Lists.newArrayList((Object[])new String[]{"par1", "par2"}), EXPECTED_OPTIONS), CREATE_TABLE_SCHEMA);
        this.catalog.createTable(singleKeyMultiplePartitionPath, (CatalogBaseTable)singleKeyMultiplePartitionTable, false);
        metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)this.catalog.inferTablePath(this.catalogPathStr, singleKeyMultiplePartitionPath));
        keyGeneratorClassName = metaClient.getTableConfig().getKeyGeneratorClassName();
        MatcherAssert.assertThat((Object)keyGeneratorClassName, (Matcher)CoreMatchers.is((Object)ComplexAvroKeyGenerator.class.getName()));
        ObjectPath multipleKeySinglePartitionPath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb_mksp" + System.currentTimeMillis());
        ResolvedCatalogTable multipleKeySinglePartitionTable = new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(CREATE_MULTI_KEY_TABLE_SCHEMA).build(), (String)"test", (List)Lists.newArrayList((Object[])new String[]{"par1"}), EXPECTED_OPTIONS), CREATE_TABLE_SCHEMA);
        this.catalog.createTable(multipleKeySinglePartitionPath, (CatalogBaseTable)multipleKeySinglePartitionTable, false);
        metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)this.catalog.inferTablePath(this.catalogPathStr, singleKeyMultiplePartitionPath));
        keyGeneratorClassName = metaClient.getTableConfig().getKeyGeneratorClassName();
        MatcherAssert.assertThat((Object)keyGeneratorClassName, (Matcher)CoreMatchers.is((Object)ComplexAvroKeyGenerator.class.getName()));
        ObjectPath nonPartitionPath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb");
        ResolvedCatalogTable nonPartitionCatalogTable = new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(CREATE_TABLE_SCHEMA).build(), (String)"test", new ArrayList(), EXPECTED_OPTIONS), CREATE_TABLE_SCHEMA);
        this.catalog.createTable(nonPartitionPath, (CatalogBaseTable)nonPartitionCatalogTable, false);
        metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)new Configuration())), (String)this.catalog.inferTablePath(this.catalogPathStr, nonPartitionPath));
        keyGeneratorClassName = metaClient.getTableConfig().getKeyGeneratorClassName();
        Assertions.assertEquals((Object)keyGeneratorClassName, (Object)NonpartitionedAvroKeyGenerator.class.getName());
    }

    @Test
    void testCreateTableWithoutPreCombineKey() {
        Map<String, String> options = this.getDefaultCatalogOption();
        options.put(FlinkOptions.PAYLOAD_CLASS_NAME.key(), DefaultHoodieRecordPayload.class.getName());
        this.catalog = new HoodieCatalog("hudi", Configuration.fromMap(options));
        this.catalog.open();
        ObjectPath tablePath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb1");
        Assertions.assertThrows(HoodieValidationException.class, () -> this.catalog.createTable(tablePath, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true), (String)"Option 'precombine.field' is required for payload class: org.apache.hudi.common.model.DefaultHoodieRecordPayload");
        Map<String, String> options2 = this.getDefaultCatalogOption();
        options2.put(FlinkOptions.PRECOMBINE_FIELD.key(), "not_exists");
        this.catalog = new HoodieCatalog("hudi", Configuration.fromMap(options2));
        this.catalog.open();
        ObjectPath tablePath2 = new ObjectPath(TEST_DEFAULT_DATABASE, "tb2");
        Assertions.assertThrows(HoodieValidationException.class, () -> this.catalog.createTable(tablePath2, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true), (String)"Field not_exists does not exist in the table schema. Please check 'precombine.field' option.");
    }

    @Test
    public void testListTable() throws Exception {
        ObjectPath tablePath1 = new ObjectPath(TEST_DEFAULT_DATABASE, "tb1");
        ObjectPath tablePath2 = new ObjectPath(TEST_DEFAULT_DATABASE, "tb2");
        this.catalog.createTable(tablePath1, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true);
        this.catalog.createTable(tablePath2, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true);
        List tables = this.catalog.listTables(TEST_DEFAULT_DATABASE);
        Assertions.assertTrue((boolean)tables.contains(tablePath1.getObjectName()));
        Assertions.assertTrue((boolean)tables.contains(tablePath2.getObjectName()));
        Assertions.assertThrows(DatabaseNotExistException.class, () -> this.catalog.listTables(NONE_EXIST_DATABASE));
    }

    @Test
    public void testGetTable() throws Exception {
        ObjectPath tablePath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb1");
        this.catalog.createTable(tablePath, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true);
        HashMap<String, String> expectedOptions = new HashMap<String, String>(EXPECTED_OPTIONS);
        expectedOptions.put(FlinkOptions.TABLE_TYPE.key(), FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
        expectedOptions.put(FlinkOptions.INDEX_GLOBAL_ENABLED.key(), "false");
        expectedOptions.put(FlinkOptions.PRE_COMBINE.key(), "true");
        expectedOptions.put("connector", "hudi");
        expectedOptions.put(FlinkOptions.PATH.key(), String.format("%s/%s/%s", this.tempFile.getAbsolutePath(), tablePath.getDatabaseName(), tablePath.getObjectName()));
        CatalogBaseTable actualTable = this.catalog.getTable(tablePath);
        Schema actualSchema = actualTable.getUnresolvedSchema();
        Schema expectedSchema = Schema.newBuilder().fromResolvedSchema(EXPECTED_TABLE_SCHEMA).build();
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
        Map actualOptions = actualTable.getOptions();
        Assertions.assertEquals(expectedOptions, (Object)actualOptions);
        Assertions.assertEquals((Object)EXPECTED_CATALOG_TABLE.getComment(), (Object)actualTable.getComment());
        Assertions.assertEquals((Object)EXPECTED_CATALOG_TABLE.getPartitionKeys(), (Object)((CatalogTable)actualTable).getPartitionKeys());
    }

    @Test
    public void testDropTable() throws Exception {
        ObjectPath tablePath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb1");
        this.catalog.createTable(tablePath, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true);
        this.catalog.dropTable(tablePath, true);
        Assertions.assertFalse((boolean)this.catalog.tableExists(tablePath));
        Assertions.assertThrows(TableNotExistException.class, () -> this.catalog.dropTable(new ObjectPath(TEST_DEFAULT_DATABASE, "non_exist"), false));
    }

    @Test
    public void testDropPartition() throws Exception {
        ObjectPath tablePath = new ObjectPath(TEST_DEFAULT_DATABASE, "tb1");
        this.catalog.createTable(tablePath, (CatalogBaseTable)EXPECTED_CATALOG_TABLE, true);
        CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("partition", "par1");
            }
        });
        Assertions.assertThrows(PartitionNotExistException.class, () -> this.catalog.dropPartition(tablePath, partitionSpec, false));
        String tablePathStr = this.catalog.inferTablePath(this.catalogPathStr, tablePath);
        Configuration flinkConf = TestConfigurations.getDefaultConf(tablePathStr);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(HadoopConfigurations.getHadoopConf((Configuration)flinkConf)), (String)tablePathStr);
        TestData.writeData(TestData.DATA_SET_INSERT, flinkConf);
        Assertions.assertTrue((boolean)this.catalog.partitionExists(tablePath, partitionSpec));
        this.catalog.dropPartition(tablePath, partitionSpec, false);
        HoodieInstant latestInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().orElse(null);
        Assertions.assertNotNull((Object)latestInstant, (String)"Delete partition commit should be completed");
        HoodieCommitMetadata commitMetadata = WriteProfiles.getCommitMetadata((String)"tb1", (Path)new Path(tablePathStr), (HoodieInstant)latestInstant, (HoodieTimeline)metaClient.getActiveTimeline());
        MatcherAssert.assertThat((Object)commitMetadata, (Matcher)CoreMatchers.instanceOf(HoodieReplaceCommitMetadata.class));
        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)commitMetadata;
        MatcherAssert.assertThat((Object)replaceCommitMetadata.getPartitionToReplaceFileIds().size(), (Matcher)CoreMatchers.is((Object)1));
        Assertions.assertFalse((boolean)this.catalog.partitionExists(tablePath, partitionSpec));
    }

    private /* synthetic */ void lambda$testCreateAndDropDatabase$2(CatalogDatabase expected) throws Throwable {
        this.catalog.createDatabase("db1", expected, false);
    }

    static {
        EXPECTED_OPTIONS.put(FlinkOptions.TABLE_TYPE.key(), FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
        EXPECTED_OPTIONS.put(FlinkOptions.INDEX_GLOBAL_ENABLED.key(), "false");
        EXPECTED_OPTIONS.put(FlinkOptions.PRE_COMBINE.key(), "true");
        EXPECTED_CATALOG_TABLE = new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(CREATE_TABLE_SCHEMA).build(), (String)"test", Arrays.asList("partition"), EXPECTED_OPTIONS), CREATE_TABLE_SCHEMA);
    }
}

