/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sink.partitioner.profile.WriteProfiles;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.catalog.HoodieCatalogTestUtils;
import org.apache.hudi.table.catalog.HoodieCatalogUtil;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.apache.hudi.util.StreamerUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieHiveCatalog {
    TableSchema schema = TableSchema.builder().field("uuid", (DataType)DataTypes.INT().notNull()).field("name", DataTypes.STRING()).field("age", DataTypes.INT()).field("infos", DataTypes.ARRAY((DataType)DataTypes.STRING())).field("par1", DataTypes.STRING()).field("ts_3", DataTypes.TIMESTAMP((int)3)).field("ts_6", DataTypes.TIMESTAMP((int)6)).primaryKey(new String[]{"uuid"}).build();
    List<String> partitions = Collections.singletonList("par1");
    TableSchema multiKeySinglePartitionTableSchema = TableSchema.builder().field("uuid", (DataType)DataTypes.INT().notNull()).field("name", (DataType)DataTypes.STRING().notNull()).field("age", DataTypes.INT()).field("par1", DataTypes.STRING()).primaryKey(new String[]{"uuid", "name"}).build();
    TableSchema singleKeyMultiPartitionTableSchema = TableSchema.builder().field("uuid", (DataType)DataTypes.INT().notNull()).field("name", DataTypes.STRING()).field("par1", DataTypes.STRING()).field("par2", DataTypes.STRING()).primaryKey(new String[]{"uuid"}).build();
    List<String> multiPartitions = Lists.newArrayList((Object[])new String[]{"par1", "par2"});
    private static HoodieHiveCatalog hoodieCatalog;
    private final ObjectPath tablePath = new ObjectPath("default", "test");

    @BeforeAll
    public static void createCatalog() {
        hoodieCatalog = HoodieCatalogTestUtils.createHiveCatalog();
        hoodieCatalog.open();
    }

    @AfterEach
    public void dropTable() throws TableNotExistException {
        hoodieCatalog.dropTable(this.tablePath, true);
    }

    @AfterAll
    public static void closeCatalog() {
        if (hoodieCatalog != null) {
            hoodieCatalog.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testCreateAndGetHoodieTable(HoodieTableType tableType) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        options.put(FlinkOptions.TABLE_TYPE.key(), tableType.toString());
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        String fieldSchema = hiveTable.getSd().getCols().stream().map(f -> f.getName() + ":" + f.getType()).collect(Collectors.joining(","));
        String expectedFieldSchema = "_hoodie_commit_time:string,_hoodie_commit_seqno:string,_hoodie_record_key:string,_hoodie_partition_path:string,_hoodie_file_name:string,uuid:int,name:string,age:int,infos:array<string>,ts_3:timestamp,ts_6:timestamp";
        Assertions.assertEquals((Object)expectedFieldSchema, (Object)fieldSchema);
        String partitionSchema = hiveTable.getPartitionKeys().stream().map(f -> f.getName() + ":" + f.getType()).collect(Collectors.joining(","));
        Assertions.assertEquals((Object)"par1:string", (Object)partitionSchema);
        String avroSchemaStr = (String)hiveTable.getParameters().get("spark.sql.sources.schema.part.0");
        String expectedAvroSchemaStr = "{\"type\":\"struct\",\"fields\":[{\"name\":\"_hoodie_commit_time\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_commit_seqno\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_record_key\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_partition_path\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"_hoodie_file_name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"uuid\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}},{\"name\":\"name\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"age\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"infos\",\"type\":{\"type\":\"array\", \"elementType\":\"string\",\"containsNull\":true},\"nullable\":true,\"metadata\":{}},{\"name\":\"ts_3\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"ts_6\",\"type\":\"timestamp\",\"nullable\":true,\"metadata\":{}},{\"name\":\"par1\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}";
        Assertions.assertEquals((Object)expectedAvroSchemaStr, (Object)avroSchemaStr);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode arrayFieldTypeNode = mapper.readTree(avroSchemaStr).get("fields").get(8).get("type");
        MatcherAssert.assertThat((Object)arrayFieldTypeNode.get("type").asText(), (Matcher)CoreMatchers.is((Object)"array"));
        MatcherAssert.assertThat((Object)arrayFieldTypeNode.get("containsNull").asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        CatalogBaseTable table1 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"hudi", table1.getOptions().get(FactoryUtil.CONNECTOR.key()));
        Assertions.assertEquals((Object)tableType.toString(), table1.getOptions().get(FlinkOptions.TABLE_TYPE.key()));
        Assertions.assertEquals((Object)"uuid", table1.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
        Assertions.assertNull(table1.getOptions().get(FlinkOptions.PRECOMBINE_FIELD.key()), (String)"preCombine key is not declared");
        String tableSchema = table1.getUnresolvedSchema().getColumns().stream().map(Schema.UnresolvedColumn::toString).collect(Collectors.joining(","));
        String expectedTableSchema = "`uuid` INT NOT NULL,`name` STRING,`age` INT,`infos` ARRAY<STRING>,`par1` STRING,`ts_3` TIMESTAMP(3),`ts_6` TIMESTAMP(6)";
        Assertions.assertEquals((Object)expectedTableSchema, (Object)tableSchema);
        Assertions.assertEquals(Collections.singletonList("uuid"), (Object)((Schema.UnresolvedPrimaryKey)table1.getUnresolvedSchema().getPrimaryKey().get()).getColumnNames());
        Assertions.assertEquals(Collections.singletonList("par1"), (Object)((CatalogTable)table1).getPartitionKeys());
        HoodieTableConfig tableConfig = (HoodieTableConfig)StreamerUtil.getTableConfig((String)((String)table1.getOptions().get(FlinkOptions.PATH.key())), (Configuration)hoodieCatalog.getHiveConf()).get();
        Option tableCreateSchema = tableConfig.getTableCreateSchema();
        Assertions.assertTrue((boolean)tableCreateSchema.isPresent(), (String)"Table should have been created");
        MatcherAssert.assertThat((Object)((Schema)tableCreateSchema.get()).getFullName(), (Matcher)CoreMatchers.is((Object)"hoodie.test.test_record"));
        options.put(FlinkOptions.RECORD_KEY_FIELD.key(), "id");
        table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)table, true);
        CatalogBaseTable table2 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"id", table2.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
        options.remove(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key());
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(HoodieCatalogTestUtils.createStorageConf(), (String)hoodieCatalog.inferTablePath(this.tablePath, (CatalogBaseTable)table));
        String keyGeneratorClassName = metaClient.getTableConfig().getKeyGeneratorClassName();
        Assertions.assertEquals((Object)keyGeneratorClassName, (Object)SimpleAvroKeyGenerator.class.getName());
        ObjectPath singleKeyMultiPartitionPath = new ObjectPath("default", "tb_skmp_" + System.currentTimeMillis());
        CatalogTableImpl singleKeyMultiPartitionTable = new CatalogTableImpl(this.singleKeyMultiPartitionTableSchema, this.multiPartitions, options, "hudi table");
        hoodieCatalog.createTable(singleKeyMultiPartitionPath, (CatalogBaseTable)singleKeyMultiPartitionTable, false);
        HoodieTableMetaClient singleKeyMultiPartitionTableMetaClient = HoodieTestUtils.createMetaClient(HoodieCatalogTestUtils.createStorageConf(), (String)hoodieCatalog.inferTablePath(singleKeyMultiPartitionPath, (CatalogBaseTable)singleKeyMultiPartitionTable));
        MatcherAssert.assertThat((Object)singleKeyMultiPartitionTableMetaClient.getTableConfig().getKeyGeneratorClassName(), (Matcher)CoreMatchers.is((Object)ComplexAvroKeyGenerator.class.getName()));
        ObjectPath multiKeySinglePartitionPath = new ObjectPath("default", "tb_mksp_" + System.currentTimeMillis());
        options.remove(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key());
        CatalogTableImpl multiKeySinglePartitionTable = new CatalogTableImpl(this.multiKeySinglePartitionTableSchema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(multiKeySinglePartitionPath, (CatalogBaseTable)multiKeySinglePartitionTable, false);
        HoodieTableMetaClient multiKeySinglePartitionTableMetaClient = HoodieTestUtils.createMetaClient(HoodieCatalogTestUtils.createStorageConf(), (String)hoodieCatalog.inferTablePath(multiKeySinglePartitionPath, (CatalogBaseTable)multiKeySinglePartitionTable));
        MatcherAssert.assertThat((Object)multiKeySinglePartitionTableMetaClient.getTableConfig().getKeyGeneratorClassName(), (Matcher)CoreMatchers.is((Object)ComplexAvroKeyGenerator.class.getName()));
        ObjectPath nonPartitionPath = new ObjectPath("default", "tb_" + tableType);
        CatalogTableImpl nonPartitionTable = new CatalogTableImpl(this.schema, new ArrayList(), options, "hudi table");
        hoodieCatalog.createTable(nonPartitionPath, (CatalogBaseTable)nonPartitionTable, false);
        metaClient = HoodieTestUtils.createMetaClient(HoodieCatalogTestUtils.createStorageConf(), (String)hoodieCatalog.inferTablePath(nonPartitionPath, (CatalogBaseTable)nonPartitionTable));
        keyGeneratorClassName = metaClient.getTableConfig().getKeyGeneratorClassName();
        Assertions.assertEquals((Object)keyGeneratorClassName, (Object)NonpartitionedAvroKeyGenerator.class.getName());
    }

    @Test
    void testCreateTableWithIndexType() throws TableNotExistException, TableAlreadyExistException, DatabaseNotExistException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        options.put(HoodieIndexConfig.INDEX_TYPE.key(), "BUCKET");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Map params = hoodieCatalog.getHiveTable(this.tablePath).getParameters();
        this.assertResult(params, "BUCKET");
        options.remove(HoodieIndexConfig.INDEX_TYPE.key());
        options.put(FlinkOptions.INDEX_TYPE.key(), FlinkOptions.INDEX_TYPE.defaultValue());
        table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        ObjectPath newTablePath1 = new ObjectPath("default", "test" + System.currentTimeMillis());
        hoodieCatalog.createTable(newTablePath1, (CatalogBaseTable)table, false);
        params = hoodieCatalog.getHiveTable(newTablePath1).getParameters();
        this.assertResult(params, (String)FlinkOptions.INDEX_TYPE.defaultValue());
        options.put(HoodieIndexConfig.INDEX_TYPE.key(), "BUCKET");
        table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        ObjectPath newTablePath2 = new ObjectPath("default", "test" + System.currentTimeMillis());
        hoodieCatalog.createTable(newTablePath2, (CatalogBaseTable)table, false);
        params = hoodieCatalog.getHiveTable(newTablePath2).getParameters();
        this.assertResult(params, "BUCKET");
    }

    private void assertResult(Map<String, String> params, String index) {
        Assertions.assertTrue((boolean)params.containsKey(HoodieIndexConfig.INDEX_TYPE.key()));
        Assertions.assertFalse((boolean)params.containsKey(FlinkOptions.INDEX_TYPE.key()));
        MatcherAssert.assertThat((Object)params.get(HoodieIndexConfig.INDEX_TYPE.key()), (Matcher)CoreMatchers.is((Object)index));
    }

    @Test
    void testCreateTableWithoutPreCombineKey() throws TableAlreadyExistException, DatabaseNotExistException, IOException, TableNotExistException {
        String db = "default";
        hoodieCatalog = HoodieCatalogTestUtils.createHiveCatalog();
        hoodieCatalog.open();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        TypedProperties props = this.createTableAndReturnTableProperties(options, new ObjectPath(db, "tmptb1"));
        Assertions.assertFalse((boolean)props.containsKey((Object)"hoodie.table.precombine.field"));
        options.put(FlinkOptions.PRECOMBINE_FIELD.key(), "ts_3");
        props = this.createTableAndReturnTableProperties(options, new ObjectPath(db, "tmptb2"));
        Assertions.assertTrue((boolean)props.containsKey((Object)"hoodie.table.precombine.field"));
        Assertions.assertEquals((Object)"ts_3", (Object)props.get((Object)"hoodie.table.precombine.field"));
    }

    private TypedProperties createTableAndReturnTableProperties(Map<String, String> options, ObjectPath tablePath) throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException {
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(tablePath, (CatalogBaseTable)table, true);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(HoodieCatalogTestUtils.createStorageConf(), (String)hoodieCatalog.inferTablePath(tablePath, (CatalogBaseTable)table));
        return metaClient.getTableConfig().getProps();
    }

    @Test
    public void testCreateExternalTable() throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException, IOException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", true);
        catalog.open();
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, originOptions, "hudi table");
        catalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table table1 = catalog.getHiveTable(this.tablePath);
        Assertions.assertTrue((boolean)Boolean.parseBoolean((String)table1.getParameters().get("EXTERNAL")));
        Assertions.assertEquals((Object)"EXTERNAL_TABLE", (Object)table1.getTableType());
        catalog.dropTable(this.tablePath, false);
        StoragePath path = new StoragePath((String)table1.getParameters().get(FlinkOptions.PATH.key()));
        boolean created = StreamerUtil.fileExists((HoodieStorage)HoodieTestUtils.getStorage((StoragePath)path), (StoragePath)path);
        Assertions.assertTrue((boolean)created, (String)"Table should have been created");
    }

    @Test
    public void testCreateNonHoodieTable() throws TableAlreadyExistException, DatabaseNotExistException {
        CatalogTableImpl table = new CatalogTableImpl(this.schema, Collections.singletonMap(FactoryUtil.CONNECTOR.key(), "hudi-fake"), "hudi table");
        try {
            hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        }
        catch (HoodieCatalogException e) {
            Assertions.assertEquals((Object)"Unsupported connector identity hudi-fake, supported identity is hudi", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateHoodieTableWithWrongTableType() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(FactoryUtil.CONNECTOR.key(), "hudi");
        properties.put("table.type", "wrong type");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, properties, "hudi table");
        Assertions.assertThrows(HoodieCatalogException.class, () -> this.lambda$testCreateHoodieTableWithWrongTableType$2((CatalogTable)table));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDropTable(boolean external) throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException, IOException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", external);
        catalog.open();
        CatalogTableImpl catalogTable = new CatalogTableImpl(this.schema, Collections.singletonMap(FactoryUtil.CONNECTOR.key(), "hudi"), "hudi table");
        catalog.createTable(this.tablePath, (CatalogBaseTable)catalogTable, false);
        Table table = catalog.getHiveTable(this.tablePath);
        Assertions.assertEquals((Object)external, (Object)Boolean.parseBoolean((String)table.getParameters().get("EXTERNAL")));
        catalog.dropTable(this.tablePath, false);
        StoragePath path = new StoragePath((String)table.getParameters().get(FlinkOptions.PATH.key()));
        boolean existing = StreamerUtil.fileExists((HoodieStorage)HoodieTestUtils.getStorage((StoragePath)path), (StoragePath)path);
        Assertions.assertEquals((Object)external, (Object)existing);
    }

    @Test
    public void testAlterTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Map newOptions = hiveTable.getParameters();
        newOptions.put("k", "v");
        CatalogTableImpl newTable = new CatalogTableImpl(this.schema, this.partitions, newOptions, "alter hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)newTable, false);
        hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Assertions.assertEquals(hiveTable.getParameters().get(FactoryUtil.CONNECTOR.key()), (Object)"hudi");
        Assertions.assertEquals(hiveTable.getParameters().get("k"), (Object)"v");
    }

    @Test
    public void testRenameTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        hoodieCatalog.renameTable(this.tablePath, "test1", false);
        Assertions.assertEquals((Object)hoodieCatalog.getHiveTable(new ObjectPath("default", "test1")).getTableName(), (Object)"test1");
        hoodieCatalog.renameTable(new ObjectPath("default", "test1"), "test", false);
    }

    @Test
    public void testDropPartition() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("par1", "20221020");
            }
        });
        Assertions.assertThrows(PartitionNotExistException.class, () -> hoodieCatalog.dropPartition(this.tablePath, partitionSpec, false));
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        StorageDescriptor partitionSd = new StorageDescriptor(hiveTable.getSd());
        partitionSd.setLocation(new org.apache.hadoop.fs.Path(partitionSd.getLocation(), HoodieCatalogUtil.inferPartitionPath((boolean)true, (CatalogPartitionSpec)partitionSpec)).toString());
        hoodieCatalog.getClient().add_partition(new Partition(Collections.singletonList("20221020"), this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), 0, 0, partitionSd, null));
        Assertions.assertNotNull((Object)this.getHivePartition(partitionSpec));
        hoodieCatalog.dropPartition(this.tablePath, partitionSpec, false);
        String tablePathStr = hoodieCatalog.inferTablePath(this.tablePath, hoodieCatalog.getTable(this.tablePath));
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration((Configuration)hoodieCatalog.getHiveConf()), (String)tablePathStr);
        HoodieInstant latestInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().orElse(null);
        Assertions.assertNotNull((Object)latestInstant, (String)"Delete partition commit should be completed");
        HoodieCommitMetadata commitMetadata = WriteProfiles.getCommitMetadata((String)this.tablePath.getObjectName(), (Path)new Path(tablePathStr), (HoodieInstant)latestInstant, (HoodieTimeline)metaClient.getActiveTimeline());
        MatcherAssert.assertThat((Object)commitMetadata, (Matcher)CoreMatchers.instanceOf(HoodieReplaceCommitMetadata.class));
        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)commitMetadata;
        MatcherAssert.assertThat((Object)replaceCommitMetadata.getPartitionToReplaceFileIds().size(), (Matcher)CoreMatchers.is((Object)1));
        Assertions.assertThrows(NoSuchObjectException.class, () -> this.getHivePartition(partitionSpec));
    }

    @Test
    public void testMappingHiveConfPropsToHiveTableParams() throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", true);
        catalog.open();
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl table = new CatalogTableImpl(this.schema, originOptions, "hudi table");
        catalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Assertions.assertEquals((Object)"false", hiveTable.getParameters().get("hadoop.hive.metastore.schema.verification"));
    }

    @Test
    public void checkParameterSemantic() throws TableAlreadyExistException, DatabaseNotExistException {
        HoodieHiveCatalog catalog = HoodieCatalogTestUtils.createHiveCatalog("myCatalog", true);
        catalog.open();
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        String pkError = String.format("Primary key fields definition has inconsistency between pk statement and option '%s'", FlinkOptions.RECORD_KEY_FIELD.key());
        originOptions.put(FlinkOptions.RECORD_KEY_FIELD.key(), "name");
        CatalogTableImpl pkTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        Assertions.assertThrows(HoodieValidationException.class, () -> this.lambda$checkParameterSemantic$5(catalog, (CatalogTable)pkTable), (String)pkError);
        originOptions.remove(FlinkOptions.RECORD_KEY_FIELD.key());
        originOptions.put(FlinkOptions.RECORD_KEY_FIELD.key(), "uuid,name");
        CatalogTableImpl pkTable1 = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        Assertions.assertThrows(HoodieValidationException.class, () -> this.lambda$checkParameterSemantic$6(catalog, (CatalogTable)pkTable1), (String)pkError);
        originOptions.remove(FlinkOptions.RECORD_KEY_FIELD.key());
        String partitionKeyError = String.format("Partition key fields definition has inconsistency between partition key statement and option '%s'", FlinkOptions.PARTITION_PATH_FIELD.key());
        originOptions.put(FlinkOptions.PARTITION_PATH_FIELD.key(), "name");
        CatalogTableImpl partitionKeytable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        Assertions.assertThrows(HoodieValidationException.class, () -> this.lambda$checkParameterSemantic$7(catalog, (CatalogTable)partitionKeytable), (String)partitionKeyError);
        originOptions.remove(FlinkOptions.PARTITION_PATH_FIELD.key());
        originOptions.put(FlinkOptions.PARTITION_PATH_FIELD.key(), "par1,name");
        CatalogTableImpl partitionKeytable1 = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        Assertions.assertThrows(HoodieValidationException.class, () -> this.lambda$checkParameterSemantic$8(catalog, (CatalogTable)partitionKeytable1), (String)partitionKeyError);
        originOptions.remove(FlinkOptions.PARTITION_PATH_FIELD.key());
    }

    private Partition getHivePartition(CatalogPartitionSpec partitionSpec) throws Exception {
        return hoodieCatalog.getClient().getPartition(this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), HoodieCatalogUtil.getOrderedPartitionValues((String)hoodieCatalog.getName(), (HiveConf)hoodieCatalog.getHiveConf(), (CatalogPartitionSpec)partitionSpec, this.partitions, (ObjectPath)this.tablePath));
    }

    private /* synthetic */ void lambda$checkParameterSemantic$8(HoodieHiveCatalog catalog, CatalogTable partitionKeytable1) throws Throwable {
        catalog.createTable(this.tablePath, (CatalogBaseTable)partitionKeytable1, false);
    }

    private /* synthetic */ void lambda$checkParameterSemantic$7(HoodieHiveCatalog catalog, CatalogTable partitionKeytable) throws Throwable {
        catalog.createTable(this.tablePath, (CatalogBaseTable)partitionKeytable, false);
    }

    private /* synthetic */ void lambda$checkParameterSemantic$6(HoodieHiveCatalog catalog, CatalogTable pkTable1) throws Throwable {
        catalog.createTable(this.tablePath, (CatalogBaseTable)pkTable1, false);
    }

    private /* synthetic */ void lambda$checkParameterSemantic$5(HoodieHiveCatalog catalog, CatalogTable pkTable) throws Throwable {
        catalog.createTable(this.tablePath, (CatalogBaseTable)pkTable, false);
    }

    private /* synthetic */ void lambda$testCreateHoodieTableWithWrongTableType$2(CatalogTable table) throws Throwable {
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
    }
}

