/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.util.ExpressionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestExpressionUtils {
    private static final DataType ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_tinyint", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"f_smallint", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"f_int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_long", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"f_double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f_boolean", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"f_decimal", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f_bytes", (DataType)DataTypes.VARBINARY((int)10)), DataTypes.FIELD((String)"f_string", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_time", (DataType)DataTypes.TIME((int)3)), DataTypes.FIELD((String)"f_date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3))}).notNull();
    private static final DataType ROW_DATA_TYPE_FIELD_NON_NULL = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_tinyint", (DataType)((DataType)DataTypes.TINYINT().notNull())), DataTypes.FIELD((String)"f_smallint", (DataType)((DataType)DataTypes.SMALLINT().notNull())), DataTypes.FIELD((String)"f_int", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"f_long", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"f_float", (DataType)((DataType)DataTypes.FLOAT().notNull())), DataTypes.FIELD((String)"f_double", (DataType)((DataType)DataTypes.DOUBLE().notNull())), DataTypes.FIELD((String)"f_boolean", (DataType)((DataType)DataTypes.BOOLEAN().notNull())), DataTypes.FIELD((String)"f_decimal", (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)2).notNull())), DataTypes.FIELD((String)"f_bytes", (DataType)((DataType)DataTypes.VARBINARY((int)10).notNull())), DataTypes.FIELD((String)"f_string", (DataType)((DataType)DataTypes.VARCHAR((int)10).notNull())), DataTypes.FIELD((String)"f_time", (DataType)((DataType)DataTypes.TIME((int)3).notNull())), DataTypes.FIELD((String)"f_date", (DataType)((DataType)DataTypes.DATE().notNull())), DataTypes.FIELD((String)"f_timestamp", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull()))}).notNull();

    TestExpressionUtils() {
    }

    @Test
    void getValueFromLiteralForNull() {
        List fields = ((RowType)ROW_DATA_TYPE.getLogicalType()).getFields();
        List dataTypes = ROW_DATA_TYPE.getChildren();
        for (int i = 0; i < fields.size(); ++i) {
            CallExpression callExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_NULL, Arrays.asList(new FieldReferenceExpression(((RowType.RowField)fields.get(i)).getName(), (DataType)dataTypes.get(i), 2, 2), new ValueLiteralExpression(null, (DataType)dataTypes.get(i))), DataTypes.BOOLEAN());
            List childExprs = callExpression.getChildren();
            boolean hasNullLiteral = childExprs.stream().anyMatch(e -> e instanceof ValueLiteralExpression && ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)((ValueLiteralExpression)e)) == null);
            Assertions.assertTrue((boolean)hasNullLiteral);
        }
    }

    @Test
    void getValueFromLiteralForNonNull() {
        List fields = ((RowType)ROW_DATA_TYPE_FIELD_NON_NULL.getLogicalType()).getFields();
        List dataTypes = ROW_DATA_TYPE_FIELD_NON_NULL.getChildren();
        ArrayList<Object> dataList = new ArrayList<Object>(fields.size());
        dataList.add(new Byte("1"));
        dataList.add(new Short("2"));
        dataList.add(new Integer("3"));
        dataList.add(new Long("4"));
        dataList.add(new Float(5.0));
        dataList.add(new Double(6.0));
        dataList.add(new Boolean(true));
        dataList.add(new BigDecimal(3.0));
        dataList.add(StringUtils.getUTF8Bytes((String)"hudi"));
        dataList.add("hudi ok");
        dataList.add(LocalTime.of(1, 11, 11));
        dataList.add(LocalDate.of(2023, 1, 2));
        dataList.add(LocalDateTime.of(2023, 1, 2, 3, 4));
        for (int i = 0; i < fields.size(); ++i) {
            CallExpression callExpression = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_NULL, Arrays.asList(new FieldReferenceExpression(((RowType.RowField)fields.get(i)).getName(), (DataType)dataTypes.get(i), i, i), new ValueLiteralExpression(dataList.get(i), (DataType)dataTypes.get(i))), DataTypes.BOOLEAN());
            List childExprs = callExpression.getChildren();
            if (dataList.get(i) instanceof LocalTime) {
                Assertions.assertEquals((Object)((LocalTime)dataList.get(i)).get(ChronoField.MILLI_OF_DAY), (Object)ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)((ValueLiteralExpression)childExprs.get(1))));
                continue;
            }
            if (dataList.get(i) instanceof LocalDate) {
                Assertions.assertEquals((Object)((int)((LocalDate)dataList.get(i)).toEpochDay()), (Object)ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)((ValueLiteralExpression)childExprs.get(1))));
                continue;
            }
            if (dataList.get(i) instanceof LocalDateTime) {
                Assertions.assertEquals((Object)((LocalDateTime)dataList.get(i)).toInstant(ZoneOffset.UTC).toEpochMilli(), (Object)ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)((ValueLiteralExpression)childExprs.get(1))));
                continue;
            }
            Assertions.assertEquals(dataList.get(i), (Object)ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)((ValueLiteralExpression)childExprs.get(1))));
        }
    }
}

