/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.streamer.FlinkStreamerConfig;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.utils.SchemaBuilder;

public class TestConfigurations {
    public static final DataType ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final RowType ROW_TYPE = (RowType)ROW_DATA_TYPE.getLogicalType();
    public static final ResolvedSchema TABLE_SCHEMA = SchemaBuilder.instance().fields(ROW_TYPE.getFieldNames(), ROW_DATA_TYPE.getChildren()).build();
    private static final List<String> FIELDS = ROW_TYPE.getFields().stream().map(RowType.RowField::asSummaryString).collect(Collectors.toList());
    public static final DataType ROW_DATA_TYPE_WIDER = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"salary", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final RowType ROW_TYPE_WIDER = (RowType)ROW_DATA_TYPE_WIDER.getLogicalType();
    public static final DataType ROW_DATA_TYPE_DATE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"dt", (DataType)DataTypes.DATE())}).notNull();
    public static final RowType ROW_TYPE_DATE = (RowType)ROW_DATA_TYPE_DATE.getLogicalType();
    public static final DataType ROW_DATA_TYPE_EVOLUTION_BEFORE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"gender", (DataType)DataTypes.CHAR((int)1)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)6)), DataTypes.FIELD((String)"f_struct", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"drop_add", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"change_type", (DataType)DataTypes.INT())})), DataTypes.FIELD((String)"f_map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT())), DataTypes.FIELD((String)"f_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.FIELD((String)"f_row_map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"drop_add", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"change_type", (DataType)DataTypes.INT())}))), DataTypes.FIELD((String)"f_row_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"drop_add", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"change_type", (DataType)DataTypes.INT())}))), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final RowType ROW_TYPE_EVOLUTION_BEFORE = (RowType)ROW_DATA_TYPE_EVOLUTION_BEFORE.getLogicalType();
    public static final DataType ROW_DATA_TYPE_EVOLUTION_AFTER = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"age", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"first_name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"last_name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"salary", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)6)), DataTypes.FIELD((String)"f_struct", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"renamed_change_type", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"drop_add", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)20, (int)0))})), DataTypes.FIELD((String)"f_map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.DOUBLE())), DataTypes.FIELD((String)"f_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.DOUBLE())), DataTypes.FIELD((String)"f_row_map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"renamed_change_type", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"drop_add", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)20, (int)0))}))), DataTypes.FIELD((String)"f_row_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"drop_add", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"change_type", (DataType)DataTypes.INT())}))), DataTypes.FIELD((String)"new_row_col", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())})), DataTypes.FIELD((String)"new_array_col", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())), DataTypes.FIELD((String)"new_map_col", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final DataType ROW_DATA_TYPE_HOODIE_KEY_SPECIAL_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f_decimal", (DataType)DataTypes.DECIMAL((int)3, (int)2))}).notNull();
    public static final RowType ROW_TYPE_HOODIE_KEY_SPECIAL_DATA_TYPE = (RowType)ROW_DATA_TYPE_HOODIE_KEY_SPECIAL_DATA_TYPE.getLogicalType();
    public static final RowType ROW_TYPE_EVOLUTION_AFTER = (RowType)ROW_DATA_TYPE_EVOLUTION_AFTER.getLogicalType();
    public static final DataType ROW_DATA_TYPE_BIGINT = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final RowType ROW_TYPE_BIGINT = (RowType)ROW_DATA_TYPE_BIGINT.getLogicalType();
    public static final RowDataSerializer SERIALIZER = new RowDataSerializer(ROW_TYPE);

    private TestConfigurations() {
    }

    public static String getCreateHoodieTableDDL(String tableName, Map<String, String> options) {
        return TestConfigurations.getCreateHoodieTableDDL(tableName, options, true, "partition");
    }

    public static String getCreateHoodieTableDDL(String tableName, Map<String, String> options, boolean havePartition, String partitionField) {
        return TestConfigurations.getCreateHoodieTableDDL(tableName, FIELDS, options, havePartition, "uuid", partitionField);
    }

    public static String getCreateHoodieTableDDL(String tableName, List<String> fields, Map<String, String> options, boolean havePartition, String pkField, String partitionField) {
        StringBuilder builder = new StringBuilder();
        builder.append("create table ").append(tableName).append("(\n");
        for (String field : fields) {
            builder.append("  ").append(field).append(",\n");
        }
        builder.append("  PRIMARY KEY(").append(pkField).append(") NOT ENFORCED\n").append(")\n");
        if (havePartition) {
            builder.append("PARTITIONED BY (`").append(partitionField).append("`)\n");
        }
        String connector = options.computeIfAbsent("connector", k -> "hudi");
        builder.append("with (\n  'connector' = '").append(connector).append("'");
        options.forEach((k, v) -> builder.append(",\n").append("  '").append((String)k).append("' = '").append((String)v).append("'"));
        builder.append("\n)");
        return builder.toString();
    }

    public static String getCreateHudiCatalogDDL(String catalogName, String catalogPath) {
        StringBuilder builder = new StringBuilder();
        builder.append("create catalog ").append(catalogName).append(" with (\n");
        builder.append("  'type' = 'hudi',\n  'catalog.path' = '").append(catalogPath).append("'");
        builder.append("\n)");
        return builder.toString();
    }

    public static String getFileSourceDDL(String tableName) {
        return TestConfigurations.getFileSourceDDL(tableName, "test_source.data");
    }

    public static String getFileSourceDDL(String tableName, int checkpoints) {
        return TestConfigurations.getFileSourceDDL(tableName, "test_source.data", checkpoints);
    }

    public static String getFileSourceDDL(String tableName, String fileName) {
        return TestConfigurations.getFileSourceDDL(tableName, fileName, 2);
    }

    public static String getFileSourceDDL(String tableName, String fileName, int checkpoints) {
        String sourcePath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(fileName)).toString();
        return "create table " + tableName + "(\n  uuid varchar(20),\n  name varchar(10),\n  age int,\n  ts timestamp(3),\n  `partition` varchar(20)\n) with (\n  'connector' = '" + "continuous-file-source" + "',\n  'path' = '" + sourcePath + "',\n  'checkpoints' = '" + checkpoints + "'\n)";
    }

    public static String getCollectSinkDDL(String tableName) {
        return "create table " + tableName + "(\n  uuid varchar(20),\n  name varchar(10),\n  age int,\n  ts timestamp(3),\n  `partition` varchar(20)\n) with (\n  'connector' = '" + "collect" + "')";
    }

    public static String getCollectSinkDDL(String tableName, TableSchema tableSchema) {
        StringBuilder builder = new StringBuilder("create table " + tableName + "(\n");
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldTypes = tableSchema.getFieldDataTypes();
        for (int i = 0; i < fieldNames.length; ++i) {
            builder.append("  `").append(fieldNames[i]).append("` ").append(fieldTypes[i].toString());
            if (i != fieldNames.length - 1) {
                builder.append(",");
            }
            builder.append("\n");
        }
        String withProps = ") with (\n  'connector' = 'collect'\n)";
        builder.append(") with (\n  'connector' = 'collect'\n)");
        return builder.toString();
    }

    public static String getCsvSourceDDL(String tableName, String fileName) {
        String sourcePath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(fileName)).toString();
        return "create table " + tableName + "(\n  uuid varchar(20),\n  name varchar(10),\n  age int,\n  ts timestamp(3),\n  `partition` varchar(20)\n) with (\n  'connector' = 'filesystem',\n  'path' = '" + sourcePath + "',\n  'format' = 'csv'\n)";
    }

    public static Configuration getDefaultConf(String tablePath) {
        Configuration conf = new Configuration();
        conf.setString(FlinkOptions.PATH, tablePath);
        conf.setString(FlinkOptions.SOURCE_AVRO_SCHEMA_PATH, Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("test_read_schema.avsc")).toString());
        conf.setString(FlinkOptions.TABLE_NAME, "TestHoodieTable");
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "partition");
        return conf;
    }

    public static Configuration getDefaultConf(String tablePath, DataType dataType) {
        Configuration conf = new Configuration();
        conf.setString(FlinkOptions.PATH, tablePath);
        conf.setString(FlinkOptions.SOURCE_AVRO_SCHEMA, AvroSchemaConverter.convertToSchema((LogicalType)dataType.getLogicalType()).toString());
        conf.setString(FlinkOptions.TABLE_NAME, "TestHoodieTable");
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "partition");
        return conf;
    }

    public static FlinkStreamerConfig getDefaultStreamerConf(String tablePath) {
        FlinkStreamerConfig streamerConf = new FlinkStreamerConfig();
        streamerConf.targetBasePath = tablePath;
        streamerConf.sourceAvroSchemaPath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("test_read_schema.avsc")).toString();
        streamerConf.targetTableName = "TestHoodieTable";
        streamerConf.partitionPathField = "partition";
        streamerConf.tableType = "COPY_ON_WRITE";
        streamerConf.checkpointInterval = 4000L;
        return streamerConf;
    }

    public static Sql sql(String tableName) {
        return new Sql(tableName);
    }

    public static Catalog catalog(String catalogName) {
        return new Catalog(catalogName);
    }

    public static class Catalog {
        private final String catalogName;
        private String catalogPath = ".";

        public Catalog(String catalogName) {
            this.catalogName = catalogName;
        }

        public Catalog catalogPath(String catalogPath) {
            this.catalogPath = catalogPath;
            return this;
        }

        public String end() {
            return TestConfigurations.getCreateHudiCatalogDDL(this.catalogName, this.catalogPath);
        }
    }

    public static class Sql {
        private final Map<String, String> options;
        private final String tableName;
        private List<String> fields = new ArrayList<String>();
        private boolean withPartition = true;
        private String pkField = "uuid";
        private String partitionField = "partition";

        public Sql(String tableName) {
            this.options = new HashMap<String, String>();
            this.tableName = tableName;
        }

        public Sql option(ConfigOption<?> option, Object val) {
            this.options.put(option.key(), val.toString());
            return this;
        }

        public Sql option(String key, Object val) {
            this.options.put(key, val.toString());
            return this;
        }

        public Sql options(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Sql noPartition() {
            this.withPartition = false;
            return this;
        }

        public Sql pkField(String pkField) {
            this.pkField = pkField;
            return this;
        }

        public Sql partitionField(String partitionField) {
            this.partitionField = partitionField;
            return this;
        }

        public Sql field(String fieldSchema) {
            this.fields.add(fieldSchema);
            return this;
        }

        public String end() {
            if (this.fields.size() == 0) {
                this.fields = FIELDS;
            }
            return TestConfigurations.getCreateHoodieTableDDL(this.tableName, this.fields, this.options, this.withPartition, this.pkField, this.partitionField);
        }
    }
}

