/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestStreamerUtil {
    @TempDir
    File tempFile;

    @Test
    void testInitTableWithSpecificVersion() throws IOException {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.set(FlinkOptions.PARTITION_PATH_FIELD, (Object)"p0,p1");
        conf.set(FlinkOptions.WRITE_TABLE_VERSION, (Object)HoodieTableVersion.SIX.versionCode());
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.createMetaClient((String)this.tempFile.getAbsolutePath());
        Assertions.assertArrayEquals((Object[])((Object[])metaClient1.getTableConfig().getPartitionFields().get()), (Object[])new String[]{"p0", "p1"});
        Assertions.assertNotNull((Object)metaClient1.getTableConfig().getKeyGeneratorClassName());
        Assertions.assertEquals((Object)HoodieTableVersion.SIX, (Object)metaClient1.getTableConfig().getTableVersion());
    }

    @Test
    void testInitTableIfNotExists() throws IOException {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.set(FlinkOptions.PRECOMBINE_FIELD, (Object)"ts");
        conf.set(FlinkOptions.PARTITION_PATH_FIELD, (Object)"p0,p1");
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.createMetaClient((String)this.tempFile.getAbsolutePath());
        Assertions.assertTrue((boolean)metaClient1.getTableConfig().getPartitionFields().isPresent(), (String)"Missing partition columns in the hoodie.properties.");
        Assertions.assertArrayEquals((Object[])((Object[])metaClient1.getTableConfig().getPartitionFields().get()), (Object[])new String[]{"p0", "p1"});
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getPreCombineField(), (Object)"ts");
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getKeyGeneratorClassName(), (Object)SimpleAvroKeyGenerator.class.getName());
        Assertions.assertEquals((Object)HoodieTableVersion.EIGHT, (Object)metaClient1.getTableConfig().getTableVersion());
        conf.removeConfig(FlinkOptions.PARTITION_PATH_FIELD);
        FileIOUtils.deleteDirectory((File)this.tempFile);
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.createMetaClient((String)this.tempFile.getAbsolutePath());
        Assertions.assertFalse((boolean)metaClient2.getTableConfig().getPartitionFields().isPresent());
        Assertions.assertEquals((Object)metaClient2.getTableConfig().getKeyGeneratorClassName(), (Object)SimpleAvroKeyGenerator.class.getName());
    }

    @Test
    void testMedianInstantTime() {
        String higher = "20210705125921";
        String lower = "20210705125806";
        String expectedMedianInstant = "20210705125844499";
        String median1 = (String)StreamerUtil.medianInstantTime((String)higher, (String)lower).get();
        MatcherAssert.assertThat((Object)median1, (Matcher)CoreMatchers.is((Object)expectedMedianInstant));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StreamerUtil.medianInstantTime((String)lower, (String)higher), (String)"The first argument should have newer instant time");
        Assertions.assertFalse((boolean)StreamerUtil.medianInstantTime((String)"20211116115634", (String)"20211116115633").isPresent());
    }

    @Test
    void testInstantTimeDiff() {
        String higher = "20210705125921";
        String lower = "20210705125806";
        long diff = StreamerUtil.instantTimeDiffSeconds((String)higher, (String)lower);
        MatcherAssert.assertThat((Object)diff, (Matcher)CoreMatchers.is((Object)75L));
    }

    @Test
    void testTableExist() throws IOException {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        String basePath = this.tempFile.getAbsolutePath();
        Assertions.assertFalse((boolean)StreamerUtil.tableExists((String)basePath, (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)conf)));
        try (FileSystem fs = HadoopFSUtils.getFs((String)basePath, (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)conf));){
            fs.mkdirs(new Path(basePath, ".hoodie"));
            Assertions.assertFalse((boolean)StreamerUtil.tableExists((String)basePath, (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)conf)));
            fs.create(new Path(new Path(basePath, ".hoodie"), "hoodie.properties"));
            Assertions.assertTrue((boolean)StreamerUtil.tableExists((String)basePath, (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)conf)));
        }
    }
}

