/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.RowDataToAvroConverters;
import org.apache.hudi.util.StringToRowDataConverter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStringToRowDataConverter {
    @Test
    void testConvert() {
        String[] fields = new String[]{"1.1", "3.4", "2021-03-30", "56669000", "1617119069000", "1617119069666111", "12345.67"};
        LogicalType[] fieldTypes = new LogicalType[]{DataTypes.FLOAT().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.DATE().getLogicalType(), DataTypes.TIME((int)3).getLogicalType(), DataTypes.TIMESTAMP((int)3).getLogicalType(), DataTypes.TIMESTAMP((int)6).getLogicalType(), DataTypes.DECIMAL((int)7, (int)2).getLogicalType()};
        StringToRowDataConverter converter = new StringToRowDataConverter(fieldTypes);
        Object[] converted = converter.convert(fields);
        Object[] expected = new Object[]{Float.valueOf(1.1f), 3.4, (int)LocalDate.parse("2021-03-30").toEpochDay(), LocalTime.parse("15:44:29").get(ChronoField.MILLI_OF_DAY), TimestampData.fromInstant((Instant)Instant.parse("2021-03-30T15:44:29Z")), TimestampData.fromInstant((Instant)Instant.parse("2021-03-30T15:44:29.666111Z")), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("12345.67"), (int)7, (int)2)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])converted);
    }

    @Test
    void testRowDataToAvroStringToRowData() {
        GenericRowData rowData = new GenericRowData(7);
        rowData.setField(0, (Object)Float.valueOf(1.1f));
        rowData.setField(1, (Object)3.4);
        rowData.setField(2, (Object)((int)LocalDate.parse("2021-03-30").toEpochDay()));
        rowData.setField(3, (Object)LocalTime.parse("15:44:29").get(ChronoField.MILLI_OF_DAY));
        rowData.setField(4, (Object)TimestampData.fromInstant((Instant)Instant.parse("2021-03-30T15:44:29Z")));
        rowData.setField(5, (Object)TimestampData.fromInstant((Instant)Instant.parse("2021-03-30T15:44:29.666111Z")));
        rowData.setField(6, (Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("12345.67"), (int)7, (int)2));
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"f_double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f_date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f_time", (DataType)DataTypes.TIME((int)3)), DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_timestamp_micros", (DataType)DataTypes.TIMESTAMP((int)6)), DataTypes.FIELD((String)"f_decimal", (DataType)DataTypes.DECIMAL((int)7, (int)2))});
        RowType rowType = (RowType)dataType.getLogicalType();
        RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)rowType);
        GenericRecord avroRecord = (GenericRecord)converter.convert(AvroSchemaConverter.convertToSchema((LogicalType)rowType), (Object)rowData);
        StringToRowDataConverter stringToRowDataConverter = new StringToRowDataConverter(rowType.getChildren().toArray(new LogicalType[0]));
        String recordKey = KeyGenUtils.getRecordKey((GenericRecord)avroRecord, (List)rowType.getFieldNames(), (boolean)false);
        String[] recordKeys = KeyGenUtils.extractRecordKeys((String)recordKey);
        Object[] convertedKeys = stringToRowDataConverter.convert(recordKeys);
        GenericRowData converted = new GenericRowData(7);
        for (int i = 0; i < 7; ++i) {
            converted.setField(i, convertedKeys[i]);
        }
        MatcherAssert.assertThat((Object)converted, (Matcher)CoreMatchers.is((Object)rowData));
    }
}

