/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.transform;

import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.client.model.HoodieFlinkInternalRow;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.sink.bulk.RowDataKeyGen;

public class RowDataToHoodieFunction<I extends RowData, O extends HoodieFlinkInternalRow>
extends RichMapFunction<I, O> {
    RowDataKeyGen keyGen;

    public RowDataToHoodieFunction(RowType rowType, Configuration config) {
        this.keyGen = RowDataKeyGen.instance(config, rowType);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
    }

    public O map(I row) throws Exception {
        return (O)new HoodieFlinkInternalRow(this.keyGen.getRecordKey((RowData)row), this.keyGen.getPartitionPath((RowData)row), HoodieOperation.fromValue((byte)row.getRowKind().toByteValue()).getName(), row);
    }
}

