/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.table.data.vector.writable.WritableBytesVector;
import org.apache.flink.table.data.vector.writable.WritableColumnVector;
import org.apache.flink.table.data.vector.writable.WritableIntVector;
import org.apache.hudi.table.format.cow.vector.reader.AbstractColumnReader;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class FixedLenBytesColumnReader<V extends WritableColumnVector>
extends AbstractColumnReader<V> {
    public FixedLenBytesColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
    }

    @Override
    protected void readBatch(int rowId, int num, V column) {
        int bytesLen = this.descriptor.getPrimitiveType().getTypeLength();
        WritableBytesVector bytesVector = (WritableBytesVector)column;
        for (int i = 0; i < num; ++i) {
            if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                byte[] bytes = this.readDataBinary(bytesLen).getBytes();
                bytesVector.appendBytes(rowId + i, bytes, 0, bytes.length);
                continue;
            }
            bytesVector.setNullAt(rowId + i);
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, V column, WritableIntVector dictionaryIds) {
        WritableBytesVector bytesVector = (WritableBytesVector)column;
        for (int i = rowId; i < rowId + num; ++i) {
            if (bytesVector.isNullAt(i)) continue;
            byte[] v = this.dictionary.decodeToBinary(dictionaryIds.getInt(i)).getBytes();
            bytesVector.appendBytes(i, v, 0, v.length);
        }
    }

    private Binary readDataBinary(int len) {
        ByteBuffer buffer = this.readDataBuffer(len);
        if (buffer.hasArray()) {
            return Binary.fromConstantByteArray((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)len);
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return Binary.fromConstantByteArray((byte[])bytes);
    }
}

