/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector.reader;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.table.data.ColumnarRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.table.format.cow.ParquetSplitReaderUtil;
import org.apache.hudi.table.format.cow.vector.ParquetDecimalVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetColumnarRowSplitReader
implements Closeable {
    private final boolean utcTimestamp;
    private final MessageType fileSchema;
    private final LogicalType[] requestedTypes;
    private final MessageType requestedSchema;
    private final long totalRowCount;
    private final WritableColumnVector[] writableVectors;
    private final VectorizedColumnBatch columnarBatch;
    private final ColumnarRowData row;
    private final int batchSize;
    private ParquetFileReader reader;
    private ColumnReader[] columnReaders;
    private long rowsReturned;
    private long totalCountLoadedSoFar;
    private int nextRow;
    private int rowsInBatch;

    public ParquetColumnarRowSplitReader(boolean utcTimestamp, boolean caseSensitive, Configuration conf, LogicalType[] selectedTypes, String[] selectedFieldNames, ColumnBatchGenerator generator, int batchSize, Path path, long splitStart, long splitLength, FilterPredicate filterPredicate, UnboundRecordFilter recordFilter) throws IOException {
        this.utcTimestamp = utcTimestamp;
        this.batchSize = batchSize;
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)path, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)splitStart, (long)(splitStart + splitLength)));
        MessageType fileSchema = footer.getFileMetaData().getSchema();
        FilterCompat.Filter filter = FilterCompat.get((FilterPredicate)filterPredicate, (UnboundRecordFilter)recordFilter);
        List blocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter, (List)footer.getBlocks(), (MessageType)fileSchema);
        this.fileSchema = footer.getFileMetaData().getSchema();
        Type[] types = ParquetColumnarRowSplitReader.clipParquetSchema((GroupType)fileSchema, selectedFieldNames, caseSensitive);
        int[] requestedIndices = IntStream.range(0, types.length).filter(i -> types[i] != null).toArray();
        Type[] readTypes = (Type[])Arrays.stream(requestedIndices).mapToObj(i -> types[i]).toArray(Type[]::new);
        this.requestedTypes = (LogicalType[])Arrays.stream(requestedIndices).mapToObj(i -> selectedTypes[i]).toArray(LogicalType[]::new);
        this.requestedSchema = (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(readTypes)).named("flink-parquet");
        this.reader = new ParquetFileReader(conf, footer.getFileMetaData(), path, blocks, this.requestedSchema.getColumns());
        long totalRowCount = 0L;
        for (BlockMetaData block : blocks) {
            totalRowCount += block.getRowCount();
        }
        this.totalRowCount = totalRowCount;
        this.nextRow = 0;
        this.rowsInBatch = 0;
        this.rowsReturned = 0L;
        this.checkSchema();
        this.writableVectors = this.createWritableVectors();
        ColumnVector[] columnVectors = ParquetColumnarRowSplitReader.patchedVector(selectedFieldNames.length, this.createReadableVectors(), requestedIndices);
        this.columnarBatch = generator.generate(columnVectors);
        this.row = new ColumnarRowData(this.columnarBatch);
    }

    private static ColumnVector[] patchedVector(int fields, ColumnVector[] vectors, int[] indices) {
        ColumnVector[] patched = new ColumnVector[fields];
        for (int i = 0; i < indices.length; ++i) {
            patched[indices[i]] = vectors[i];
        }
        return patched;
    }

    private static Type[] clipParquetSchema(GroupType parquetSchema, String[] fieldNames, boolean caseSensitive) {
        Type[] types = new Type[fieldNames.length];
        if (caseSensitive) {
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                types[i] = parquetSchema.containsField(fieldName) ? parquetSchema.getType(fieldName) : null;
            }
        } else {
            HashMap<String, Type> caseInsensitiveFieldMap = new HashMap<String, Type>();
            for (Type type : parquetSchema.getFields()) {
                caseInsensitiveFieldMap.compute(type.getName().toLowerCase(Locale.ROOT), (key, previousType) -> {
                    if (previousType != null) {
                        throw new FlinkRuntimeException("Parquet with case insensitive mode should have no duplicate key: " + key);
                    }
                    return type;
                });
            }
            for (int i = 0; i < fieldNames.length; ++i) {
                Type type;
                types[i] = type = (Type)caseInsensitiveFieldMap.get(fieldNames[i].toLowerCase(Locale.ROOT));
            }
        }
        return types;
    }

    private WritableColumnVector[] createWritableVectors() {
        WritableColumnVector[] columns = new WritableColumnVector[this.requestedTypes.length];
        List types = this.requestedSchema.getFields();
        List descriptors = this.requestedSchema.getColumns();
        for (int i = 0; i < this.requestedTypes.length; ++i) {
            try {
                columns[i] = ParquetSplitReaderUtil.createWritableColumnVector(this.batchSize, this.requestedTypes[i], (Type)types.get(i), descriptors);
                continue;
            }
            catch (IllegalArgumentException e) {
                String fieldName = this.requestedSchema.getFieldName(i);
                String message = e.getMessage() + " Field name: " + fieldName;
                throw new IllegalArgumentException(message);
            }
        }
        return columns;
    }

    private ColumnVector[] createReadableVectors() {
        ColumnVector[] vectors = new ColumnVector[this.writableVectors.length];
        for (int i = 0; i < this.writableVectors.length; ++i) {
            vectors[i] = this.requestedTypes[i].getTypeRoot() == LogicalTypeRoot.DECIMAL ? new ParquetDecimalVector((ColumnVector)this.writableVectors[i]) : this.writableVectors[i];
        }
        return vectors;
    }

    private void checkSchema() throws IOException, UnsupportedOperationException {
        for (int i = 0; i < this.requestedSchema.getFieldCount(); ++i) {
            Object[] colPath = (String[])this.requestedSchema.getPaths().get(i);
            if (this.fileSchema.containsPath((String[])colPath)) {
                ColumnDescriptor fd = this.fileSchema.getColumnDescription((String[])colPath);
                if (fd.equals(this.requestedSchema.getColumns().get(i))) continue;
                throw new UnsupportedOperationException("Schema evolution not supported.");
            }
            if (((ColumnDescriptor)this.requestedSchema.getColumns().get(i)).getMaxDefinitionLevel() != 0) continue;
            throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(colPath));
        }
    }

    public boolean reachedEnd() throws IOException {
        return !this.ensureBatch();
    }

    public RowData nextRecord() {
        this.row.setRowId(this.nextRow++);
        return this.row;
    }

    private boolean ensureBatch() throws IOException {
        if (this.nextRow >= this.rowsInBatch) {
            this.nextRow = 0;
            return this.nextBatch();
        }
        return true;
    }

    private boolean nextBatch() throws IOException {
        for (WritableColumnVector v : this.writableVectors) {
            v.reset();
        }
        this.columnarBatch.setNumRows(0);
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        if (this.rowsReturned == this.totalCountLoadedSoFar) {
            this.readNextRowGroup();
        }
        int num = (int)Math.min((long)this.batchSize, this.totalCountLoadedSoFar - this.rowsReturned);
        for (int i = 0; i < this.columnReaders.length; ++i) {
            this.columnReaders[i].readToVector(num, this.writableVectors[i]);
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        this.rowsInBatch = num;
        return true;
    }

    private void readNextRowGroup() throws IOException {
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List types = this.requestedSchema.getFields();
        List columns = this.requestedSchema.getColumns();
        this.columnReaders = new ColumnReader[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            this.columnReaders[i] = ParquetSplitReaderUtil.createColumnReader(this.utcTimestamp, this.requestedTypes[i], (Type)types.get(i), columns, pages);
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    public void seekToRow(long rowCount) throws IOException {
        BlockMetaData metaData;
        if (this.totalCountLoadedSoFar != 0L) {
            throw new UnsupportedOperationException("Only support seek at first.");
        }
        List blockMetaData = this.reader.getRowGroups();
        Iterator iterator = blockMetaData.iterator();
        while (iterator.hasNext() && (metaData = (BlockMetaData)iterator.next()).getRowCount() <= rowCount) {
            this.reader.skipNextRowGroup();
            this.rowsReturned += metaData.getRowCount();
            this.totalCountLoadedSoFar += metaData.getRowCount();
            this.rowsInBatch = (int)metaData.getRowCount();
            this.nextRow = (int)metaData.getRowCount();
            rowCount -= metaData.getRowCount();
        }
        int i = 0;
        while ((long)i < rowCount) {
            boolean end = this.reachedEnd();
            if (end) {
                throw new RuntimeException("Seek to many rows.");
            }
            this.nextRecord();
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public static interface ColumnBatchGenerator {
        public VectorizedColumnBatch generate(ColumnVector[] var1);
    }
}

