/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBooleanVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapByteVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapDoubleVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapFloatVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapIntVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapLongVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapShortVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapTimestampVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hudi.table.format.cow.vector.HeapArrayVector;
import org.apache.hudi.table.format.cow.vector.ParquetDecimalVector;
import org.apache.hudi.table.format.cow.vector.reader.BaseVectorizedColumnReader;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ArrayColumnReader
extends BaseVectorizedColumnReader {
    private Object lastValue;
    private boolean eof = false;
    boolean isFirstRow = true;

    public ArrayColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean isUtcTimestamp, Type type, LogicalType logicalType) throws IOException {
        super(descriptor, pageReader, isUtcTimestamp, type, logicalType);
    }

    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        HeapArrayVector lcv = (HeapArrayVector)vector;
        lcv.offsets = new long[2048];
        lcv.lengths = new long[2048];
        ArrayList<Object> valueList = new ArrayList<Object>();
        LogicalType category = ((ArrayType)this.logicalType).getElementType();
        if (this.isFirstRow) {
            if (!this.fetchNextValue(category)) {
                return;
            }
            this.isFirstRow = false;
        }
        int index = this.collectDataFromParquetPage(readNumber, lcv, valueList, category);
        this.fillColumnVector(category, lcv, valueList, index);
    }

    private boolean fetchNextValue(LogicalType category) throws IOException {
        int left = this.readPageIfNeed();
        if (left > 0) {
            this.readRepetitionAndDefinitionLevels();
            this.lastValue = this.definitionLevel == this.maxDefLevel ? (this.isCurrentPageDictionaryEncoded ? Integer.valueOf(this.dataColumn.readValueDictionaryId()) : this.readPrimitiveTypedRow(category)) : null;
            return true;
        }
        this.eof = true;
        return false;
    }

    private int readPageIfNeed() throws IOException {
        int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        if (leftInPage == 0) {
            this.readPage();
            leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        }
        return leftInPage;
    }

    private Object readPrimitiveTypedRow(LogicalType category) {
        switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dataColumn.readString();
            }
            case BOOLEAN: {
                return this.dataColumn.readBoolean();
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dataColumn.readInteger();
            }
            case TINYINT: {
                return this.dataColumn.readTinyInt();
            }
            case SMALLINT: {
                return this.dataColumn.readSmallInt();
            }
            case BIGINT: {
                return this.dataColumn.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.dataColumn.readFloat());
            }
            case DOUBLE: {
                return this.dataColumn.readDouble();
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dataColumn.readInteger();
                    }
                    case INT64: {
                        return this.dataColumn.readLong();
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dataColumn.readString();
                    }
                }
                throw new AssertionError();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.dataColumn.readTimestamp();
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private Object dictionaryDecodeValue(LogicalType category, Integer dictionaryValue) {
        if (dictionaryValue == null) {
            return null;
        }
        switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dictionary.readString(dictionaryValue);
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dictionary.readInteger(dictionaryValue);
            }
            case BOOLEAN: {
                return this.dictionary.readBoolean(dictionaryValue) ? 1 : 0;
            }
            case DOUBLE: {
                return this.dictionary.readDouble(dictionaryValue);
            }
            case FLOAT: {
                return Float.valueOf(this.dictionary.readFloat(dictionaryValue));
            }
            case TINYINT: {
                return this.dictionary.readTinyInt(dictionaryValue);
            }
            case SMALLINT: {
                return this.dictionary.readSmallInt(dictionaryValue);
            }
            case BIGINT: {
                return this.dictionary.readLong(dictionaryValue);
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dictionary.readInteger(dictionaryValue);
                    }
                    case INT64: {
                        return this.dictionary.readLong(dictionaryValue);
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dictionary.readString(dictionaryValue);
                    }
                }
                throw new AssertionError();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.dictionary.readTimestamp(dictionaryValue);
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private int collectDataFromParquetPage(int total, HeapArrayVector lcv, List<Object> valueList, LogicalType category) throws IOException {
        int index;
        for (index = 0; !this.eof && index < total; ++index) {
            lcv.offsets[index] = valueList.size();
            do {
                if (this.definitionLevel == 0) {
                    lcv.setNullAt(index);
                }
                valueList.add(this.isCurrentPageDictionaryEncoded ? this.dictionaryDecodeValue(category, (Integer)this.lastValue) : this.lastValue);
            } while (this.fetchNextValue(category) && this.repetitionLevel != 0);
            lcv.lengths[index] = (long)valueList.size() - lcv.offsets[index];
        }
        return index;
    }

    private void setChildrenInfo(HeapArrayVector lcv, int itemNum, int elementNum) {
        lcv.setSize(itemNum);
        long[] lcvLength = new long[elementNum];
        long[] lcvOffset = new long[elementNum];
        System.arraycopy(lcv.lengths, 0, lcvLength, 0, elementNum);
        System.arraycopy(lcv.offsets, 0, lcvOffset, 0, elementNum);
        lcv.lengths = lcvLength;
        lcv.offsets = lcvOffset;
    }

    private void fillColumnVector(LogicalType category, HeapArrayVector lcv, List valueList, int elementNum) {
        int total = valueList.size();
        this.setChildrenInfo(lcv, total, elementNum);
        block0 : switch (category.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                lcv.child = new HeapBytesVector(total);
                ((HeapBytesVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    byte[] src = (byte[])valueList.get(i);
                    if (src == null) {
                        ((HeapBytesVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapBytesVector)lcv.child).appendBytes(i, src, 0, src.length);
                }
                break;
            }
            case BOOLEAN: {
                lcv.child = new HeapBooleanVector(total);
                ((HeapBooleanVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapBooleanVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapBooleanVector)lcv.child).vector[i] = (Boolean)valueList.get(i);
                }
                break;
            }
            case TINYINT: {
                lcv.child = new HeapByteVector(total);
                ((HeapByteVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapByteVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapByteVector)lcv.child).vector[i] = (byte)((Integer)valueList.get(i)).intValue();
                }
                break;
            }
            case SMALLINT: {
                lcv.child = new HeapShortVector(total);
                ((HeapShortVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapShortVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapShortVector)lcv.child).vector[i] = (short)((Integer)valueList.get(i)).intValue();
                }
                break;
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                lcv.child = new HeapIntVector(total);
                ((HeapIntVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapIntVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapIntVector)lcv.child).vector[i] = (Integer)valueList.get(i);
                }
                break;
            }
            case FLOAT: {
                lcv.child = new HeapFloatVector(total);
                ((HeapFloatVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapFloatVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapFloatVector)lcv.child).vector[i] = ((Float)valueList.get(i)).floatValue();
                }
                break;
            }
            case BIGINT: {
                lcv.child = new HeapLongVector(total);
                ((HeapLongVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapLongVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapLongVector)lcv.child).vector[i] = (Long)valueList.get(i);
                }
                break;
            }
            case DOUBLE: {
                lcv.child = new HeapDoubleVector(total);
                ((HeapDoubleVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapDoubleVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapDoubleVector)lcv.child).vector[i] = (Double)valueList.get(i);
                }
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                lcv.child = new HeapTimestampVector(total);
                ((HeapTimestampVector)lcv.child).reset();
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapTimestampVector)lcv.child).setNullAt(i);
                        continue;
                    }
                    ((HeapTimestampVector)lcv.child).setTimestamp(i, (TimestampData)valueList.get(i));
                }
                break;
            }
            case DECIMAL: {
                PrimitiveType.PrimitiveTypeName primitiveTypeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
                switch (primitiveTypeName) {
                    case INT32: {
                        lcv.child = new ParquetDecimalVector((ColumnVector)new HeapIntVector(total));
                        ((HeapIntVector)((ParquetDecimalVector)lcv.child).vector).reset();
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                ((HeapIntVector)((ParquetDecimalVector)lcv.child).vector).setNullAt(i);
                                continue;
                            }
                            ((HeapIntVector)((ParquetDecimalVector)lcv.child).vector).vector[i] = (Integer)valueList.get(i);
                        }
                        break block0;
                    }
                    case INT64: {
                        lcv.child = new ParquetDecimalVector((ColumnVector)new HeapLongVector(total));
                        ((HeapLongVector)((ParquetDecimalVector)lcv.child).vector).reset();
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                ((HeapLongVector)((ParquetDecimalVector)lcv.child).vector).setNullAt(i);
                                continue;
                            }
                            ((HeapLongVector)((ParquetDecimalVector)lcv.child).vector).vector[i] = (Long)valueList.get(i);
                        }
                        break block0;
                    }
                    default: {
                        lcv.child = new ParquetDecimalVector((ColumnVector)new HeapBytesVector(total));
                        ((HeapBytesVector)((ParquetDecimalVector)lcv.child).vector).reset();
                        for (int i = 0; i < valueList.size(); ++i) {
                            byte[] src = (byte[])valueList.get(i);
                            if (valueList.get(i) == null) {
                                ((HeapBytesVector)((ParquetDecimalVector)lcv.child).vector).setNullAt(i);
                                continue;
                            }
                            ((HeapBytesVector)((ParquetDecimalVector)lcv.child).vector).appendBytes(i, src, 0, src.length);
                        }
                        break block0;
                    }
                }
            }
            default: {
                throw new RuntimeException("Unsupported type in the list: " + this.type);
            }
        }
    }
}

