/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.pool;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.pool.KryoCallback;
import io.hops.hudi.com.esotericsoftware.kryo.pool.KryoFactory;
import io.hops.hudi.com.esotericsoftware.kryo.pool.KryoPool;
import java.util.Queue;

class KryoPoolQueueImpl
implements KryoPool {
    private final Queue<Kryo> queue;
    private final KryoFactory factory;

    KryoPoolQueueImpl(KryoFactory factory, Queue<Kryo> queue) {
        this.factory = factory;
        this.queue = queue;
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public Kryo borrow() {
        Kryo res = this.queue.poll();
        if (res != null) {
            return res;
        }
        return this.factory.create();
    }

    @Override
    public void release(Kryo kryo) {
        this.queue.offer(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(KryoCallback<T> callback) {
        Kryo kryo = this.borrow();
        try {
            T t = callback.execute(kryo);
            return t;
        }
        finally {
            this.release(kryo);
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

