/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer;

import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.LongLongHashMap;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.LongPriorityQueue;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PoolArena;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PoolChunkList;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PoolChunkMetric;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PoolSubpage;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PoolThreadCache;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBuf;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.LongCounter;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int SIZE_BIT_LENGTH = 15;
    private static final int INUSED_BIT_LENGTH = 1;
    private static final int SUBPAGE_BIT_LENGTH = 1;
    private static final int BITMAP_IDX_BIT_LENGTH = 32;
    static final int IS_SUBPAGE_SHIFT = 32;
    static final int IS_USED_SHIFT = 33;
    static final int SIZE_SHIFT = 34;
    static final int RUN_OFFSET_SHIFT = 49;
    final PoolArena<T> arena;
    final Object base;
    final T memory;
    final boolean unpooled;
    private final LongLongHashMap runsAvailMap;
    private final LongPriorityQueue[] runsAvail;
    private final PoolSubpage<T>[] subpages;
    private final LongCounter pinnedBytes = PlatformDependent.newLongCounter();
    private final int pageSize;
    private final int pageShifts;
    private final int chunkSize;
    private final Deque<ByteBuffer> cachedNioBuffers;
    int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> arena, Object base, T memory, int pageSize, int pageShifts, int chunkSize, int maxPageIdx) {
        this.unpooled = false;
        this.arena = arena;
        this.base = base;
        this.memory = memory;
        this.pageSize = pageSize;
        this.pageShifts = pageShifts;
        this.chunkSize = chunkSize;
        this.freeBytes = chunkSize;
        this.runsAvail = PoolChunk.newRunsAvailqueueArray(maxPageIdx);
        this.runsAvailMap = new LongLongHashMap(-1L);
        this.subpages = new PoolSubpage[chunkSize >> pageShifts];
        int pages = chunkSize >> pageShifts;
        long initHandle = (long)pages << 34;
        this.insertAvailRun(0, pages, initHandle);
        this.cachedNioBuffers = new ArrayDeque<ByteBuffer>(8);
    }

    PoolChunk(PoolArena<T> arena, Object base, T memory, int size) {
        this.unpooled = true;
        this.arena = arena;
        this.base = base;
        this.memory = memory;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.runsAvailMap = null;
        this.runsAvail = null;
        this.subpages = null;
        this.chunkSize = size;
        this.cachedNioBuffers = null;
    }

    private static LongPriorityQueue[] newRunsAvailqueueArray(int size) {
        LongPriorityQueue[] queueArray = new LongPriorityQueue[size];
        for (int i = 0; i < queueArray.length; ++i) {
            queueArray[i] = new LongPriorityQueue();
        }
        return queueArray;
    }

    private void insertAvailRun(int runOffset, int pages, long handle2) {
        int pageIdxFloor = this.arena.pages2pageIdxFloor(pages);
        LongPriorityQueue queue = this.runsAvail[pageIdxFloor];
        queue.offer(handle2);
        this.insertAvailRun0(runOffset, handle2);
        if (pages > 1) {
            this.insertAvailRun0(PoolChunk.lastPage(runOffset, pages), handle2);
        }
    }

    private void insertAvailRun0(int runOffset, long handle2) {
        long pre = this.runsAvailMap.put(runOffset, handle2);
        assert (pre == -1L);
    }

    private void removeAvailRun(long handle2) {
        int pageIdxFloor = this.arena.pages2pageIdxFloor(PoolChunk.runPages(handle2));
        LongPriorityQueue queue = this.runsAvail[pageIdxFloor];
        this.removeAvailRun(queue, handle2);
    }

    private void removeAvailRun(LongPriorityQueue queue, long handle2) {
        queue.remove(handle2);
        int runOffset = PoolChunk.runOffset(handle2);
        int pages = PoolChunk.runPages(handle2);
        this.runsAvailMap.remove(runOffset);
        if (pages > 1) {
            this.runsAvailMap.remove(PoolChunk.lastPage(runOffset, pages));
        }
    }

    private static int lastPage(int runOffset, int pages) {
        return runOffset + pages - 1;
    }

    private long getAvailRunByOffset(int runOffset) {
        return this.runsAvailMap.get(runOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int usage() {
        int freeBytes;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            freeBytes = this.freeBytes;
        }
        return this.usage(freeBytes);
    }

    private int usage(int freeBytes) {
        if (freeBytes == 0) {
            return 100;
        }
        int freePercentage = (int)((long)freeBytes * 100L / (long)this.chunkSize);
        if (freePercentage == 0) {
            return 99;
        }
        return 100 - freePercentage;
    }

    boolean allocate(PooledByteBuf<T> buf, int reqCapacity, int sizeIdx, PoolThreadCache cache) {
        long handle2;
        if (sizeIdx <= this.arena.smallMaxSizeIdx) {
            handle2 = this.allocateSubpage(sizeIdx);
            if (handle2 < 0L) {
                return false;
            }
            assert (PoolChunk.isSubpage(handle2));
        } else {
            int runSize = this.arena.sizeIdx2size(sizeIdx);
            handle2 = this.allocateRun(runSize);
            if (handle2 < 0L) {
                return false;
            }
            assert (!PoolChunk.isSubpage(handle2));
        }
        ByteBuffer nioBuffer = this.cachedNioBuffers != null ? this.cachedNioBuffers.pollLast() : null;
        this.initBuf(buf, nioBuffer, handle2, reqCapacity, cache);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateRun(int runSize) {
        int pages = runSize >> this.pageShifts;
        int pageIdx = this.arena.pages2pageIdx(pages);
        LongPriorityQueue[] longPriorityQueueArray = this.runsAvail;
        synchronized (this.runsAvail) {
            int queueIdx = this.runFirstBestFit(pageIdx);
            if (queueIdx == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1L;
            }
            LongPriorityQueue queue = this.runsAvail[queueIdx];
            long handle2 = queue.poll();
            assert (handle2 != -1L && !PoolChunk.isUsed(handle2)) : "invalid handle: " + handle2;
            this.removeAvailRun(queue, handle2);
            if (handle2 != -1L) {
                handle2 = this.splitLargeRun(handle2, pages);
            }
            int pinnedSize = PoolChunk.runSize(this.pageShifts, handle2);
            this.freeBytes -= pinnedSize;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return handle2;
        }
    }

    private int calculateRunSize(int sizeIdx) {
        int nElements;
        int maxElements = 1 << this.pageShifts - 4;
        int runSize = 0;
        int elemSize = this.arena.sizeIdx2size(sizeIdx);
        while ((nElements = (runSize += this.pageSize) / elemSize) < maxElements && runSize != nElements * elemSize) {
        }
        while (nElements > maxElements) {
            nElements = (runSize -= this.pageSize) / elemSize;
        }
        assert (nElements > 0);
        assert (runSize <= this.chunkSize);
        assert (runSize >= elemSize);
        return runSize;
    }

    private int runFirstBestFit(int pageIdx) {
        if (this.freeBytes == this.chunkSize) {
            return this.arena.nPSizes - 1;
        }
        for (int i = pageIdx; i < this.arena.nPSizes; ++i) {
            LongPriorityQueue queue = this.runsAvail[i];
            if (queue == null || queue.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private long splitLargeRun(long handle2, int needPages) {
        assert (needPages > 0);
        int totalPages = PoolChunk.runPages(handle2);
        assert (needPages <= totalPages);
        int remPages = totalPages - needPages;
        if (remPages > 0) {
            int runOffset = PoolChunk.runOffset(handle2);
            int availOffset = runOffset + needPages;
            long availRun = PoolChunk.toRunHandle(availOffset, remPages, 0);
            this.insertAvailRun(availOffset, remPages, availRun);
            return PoolChunk.toRunHandle(runOffset, needPages, 1);
        }
        return handle2 |= 0x200000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateSubpage(int sizeIdx) {
        PoolSubpage<T> head;
        PoolSubpage<T> poolSubpage = head = this.arena.findSubpagePoolHead(sizeIdx);
        synchronized (poolSubpage) {
            int runSize = this.calculateRunSize(sizeIdx);
            long runHandle = this.allocateRun(runSize);
            if (runHandle < 0L) {
                return -1L;
            }
            int runOffset = PoolChunk.runOffset(runHandle);
            assert (this.subpages[runOffset] == null);
            int elemSize = this.arena.sizeIdx2size(sizeIdx);
            PoolSubpage<T> subpage = new PoolSubpage<T>(head, this, this.pageShifts, runOffset, PoolChunk.runSize(this.pageShifts, runHandle), elemSize);
            this.subpages[runOffset] = subpage;
            return subpage.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long handle2, int normCapacity, ByteBuffer nioBuffer) {
        int runSize = PoolChunk.runSize(this.pageShifts, handle2);
        if (PoolChunk.isSubpage(handle2)) {
            int sizeIdx = this.arena.size2SizeIdx(normCapacity);
            PoolSubpage<T> head = this.arena.findSubpagePoolHead(sizeIdx);
            int sIdx = PoolChunk.runOffset(handle2);
            PoolSubpage<T> subpage = this.subpages[sIdx];
            assert (subpage != null && subpage.doNotDestroy);
            PoolSubpage<T> poolSubpage = head;
            synchronized (poolSubpage) {
                if (subpage.free(head, PoolChunk.bitmapIdx(handle2))) {
                    return;
                }
                assert (!subpage.doNotDestroy);
                this.subpages[sIdx] = null;
            }
        }
        LongPriorityQueue[] longPriorityQueueArray = this.runsAvail;
        synchronized (this.runsAvail) {
            long finalRun = this.collapseRuns(handle2);
            finalRun &= 0xFFFFFFFDFFFFFFFFL;
            this.insertAvailRun(PoolChunk.runOffset(finalRun &= 0xFFFFFFFEFFFFFFFFL), PoolChunk.runPages(finalRun), finalRun);
            this.freeBytes += runSize;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (nioBuffer != null && this.cachedNioBuffers != null && this.cachedNioBuffers.size() < PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK) {
                this.cachedNioBuffers.offer(nioBuffer);
            }
            return;
        }
    }

    private long collapseRuns(long handle2) {
        return this.collapseNext(this.collapsePast(handle2));
    }

    private long collapsePast(long handle2) {
        while (true) {
            int runOffset = PoolChunk.runOffset(handle2);
            int runPages = PoolChunk.runPages(handle2);
            long pastRun = this.getAvailRunByOffset(runOffset - 1);
            if (pastRun == -1L) {
                return handle2;
            }
            int pastOffset = PoolChunk.runOffset(pastRun);
            int pastPages = PoolChunk.runPages(pastRun);
            if (pastRun == handle2 || pastOffset + pastPages != runOffset) break;
            this.removeAvailRun(pastRun);
            handle2 = PoolChunk.toRunHandle(pastOffset, pastPages + runPages, 0);
        }
        return handle2;
    }

    private long collapseNext(long handle2) {
        while (true) {
            int runPages;
            int runOffset;
            long nextRun;
            if ((nextRun = this.getAvailRunByOffset((runOffset = PoolChunk.runOffset(handle2)) + (runPages = PoolChunk.runPages(handle2)))) == -1L) {
                return handle2;
            }
            int nextOffset = PoolChunk.runOffset(nextRun);
            int nextPages = PoolChunk.runPages(nextRun);
            if (nextRun == handle2 || runOffset + runPages != nextOffset) break;
            this.removeAvailRun(nextRun);
            handle2 = PoolChunk.toRunHandle(runOffset, runPages + nextPages, 0);
        }
        return handle2;
    }

    private static long toRunHandle(int runOffset, int runPages, int inUsed) {
        return (long)runOffset << 49 | (long)runPages << 34 | (long)inUsed << 33;
    }

    void initBuf(PooledByteBuf<T> buf, ByteBuffer nioBuffer, long handle2, int reqCapacity, PoolThreadCache threadCache) {
        if (PoolChunk.isSubpage(handle2)) {
            this.initBufWithSubpage(buf, nioBuffer, handle2, reqCapacity, threadCache);
        } else {
            int maxLength = PoolChunk.runSize(this.pageShifts, handle2);
            buf.init(this, nioBuffer, handle2, PoolChunk.runOffset(handle2) << this.pageShifts, reqCapacity, maxLength, this.arena.parent.threadCache());
        }
    }

    void initBufWithSubpage(PooledByteBuf<T> buf, ByteBuffer nioBuffer, long handle2, int reqCapacity, PoolThreadCache threadCache) {
        int runOffset = PoolChunk.runOffset(handle2);
        int bitmapIdx = PoolChunk.bitmapIdx(handle2);
        PoolSubpage<T> s = this.subpages[runOffset];
        assert (s.doNotDestroy);
        assert (reqCapacity <= s.elemSize) : reqCapacity + "<=" + s.elemSize;
        int offset = (runOffset << this.pageShifts) + bitmapIdx * s.elemSize;
        buf.init(this, nioBuffer, handle2, offset, reqCapacity, s.elemSize, threadCache);
    }

    void incrementPinnedMemory(int delta) {
        assert (delta > 0);
        this.pinnedBytes.add(delta);
    }

    void decrementPinnedMemory(int delta) {
        assert (delta > 0);
        this.pinnedBytes.add(-delta);
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeBytes() {
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            return this.freeBytes;
        }
    }

    public int pinnedBytes() {
        return (int)this.pinnedBytes.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int freeBytes;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            freeBytes = this.freeBytes;
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(freeBytes) + "%, " + (this.chunkSize - freeBytes) + '/' + this.chunkSize + ')';
    }

    void destroy() {
        this.arena.destroyChunk(this);
    }

    static int runOffset(long handle2) {
        return (int)(handle2 >> 49);
    }

    static int runSize(int pageShifts, long handle2) {
        return PoolChunk.runPages(handle2) << pageShifts;
    }

    static int runPages(long handle2) {
        return (int)(handle2 >> 34 & 0x7FFFL);
    }

    static boolean isUsed(long handle2) {
        return (handle2 >> 33 & 1L) == 1L;
    }

    static boolean isRun(long handle2) {
        return !PoolChunk.isSubpage(handle2);
    }

    static boolean isSubpage(long handle2) {
        return (handle2 >> 32 & 1L) == 1L;
    }

    static int bitmapIdx(long handle2) {
        return (int)handle2;
    }
}

