/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.conn;

import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.annotation.Contract;
import io.hops.hudi.org.apache.http.annotation.ThreadingBehavior;
import io.hops.hudi.org.apache.http.conn.SchemePortResolver;
import io.hops.hudi.org.apache.http.conn.UnsupportedSchemeException;
import io.hops.hudi.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host2) throws UnsupportedSchemeException {
        Args.notNull(host2, "HTTP host");
        int port = host2.getPort();
        if (port > 0) {
            return port;
        }
        String name = host2.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

