/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.io;

import io.hops.hudi.org.apache.jetty.io.ArrayByteBufferPool;
import io.hops.hudi.org.apache.jetty.io.ByteBufferPool;

public class LogarithmicArrayByteBufferPool
extends ArrayByteBufferPool {
    public LogarithmicArrayByteBufferPool() {
        this(-1, -1, -1);
    }

    public LogarithmicArrayByteBufferPool(int minCapacity, int maxCapacity) {
        this(minCapacity, maxCapacity, -1, -1L, -1L);
    }

    public LogarithmicArrayByteBufferPool(int minCapacity, int maxCapacity, int maxQueueLength) {
        this(minCapacity, maxCapacity, maxQueueLength, -1L, -1L);
    }

    public LogarithmicArrayByteBufferPool(int minCapacity, int maxCapacity, int maxQueueLength, long maxHeapMemory, long maxDirectMemory) {
        super(minCapacity, 1, maxCapacity, maxQueueLength, maxHeapMemory, maxDirectMemory);
    }

    @Override
    protected int bucketFor(int capacity) {
        return 32 - Integer.numberOfLeadingZeros(capacity - 1);
    }

    @Override
    protected int capacityFor(int bucket) {
        return 1 << bucket;
    }

    @Override
    protected void releaseMemory(boolean direct) {
        long oldest = Long.MAX_VALUE;
        int index = -1;
        ByteBufferPool.Bucket[] buckets = this.bucketsFor(direct);
        for (int i = 0; i < buckets.length; ++i) {
            long lastUpdate;
            ByteBufferPool.Bucket bucket = buckets[i];
            if (bucket.isEmpty() || (lastUpdate = bucket.getLastUpdate()) >= oldest) continue;
            oldest = lastUpdate;
            index = i;
        }
        if (index >= 0) {
            ByteBufferPool.Bucket bucket = buckets[index];
            bucket.acquire();
            bucket.resetUpdateTime();
        }
    }
}

