/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.objenesis.strategy;

import io.hops.hudi.org.objenesis.instantiator.ObjectInstantiator;
import io.hops.hudi.org.objenesis.instantiator.android.Android10Instantiator;
import io.hops.hudi.org.objenesis.instantiator.android.Android17Instantiator;
import io.hops.hudi.org.objenesis.instantiator.android.Android18Instantiator;
import io.hops.hudi.org.objenesis.instantiator.basic.AccessibleInstantiator;
import io.hops.hudi.org.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import io.hops.hudi.org.objenesis.instantiator.gcj.GCJInstantiator;
import io.hops.hudi.org.objenesis.instantiator.perc.PercInstantiator;
import io.hops.hudi.org.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import io.hops.hudi.org.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import io.hops.hudi.org.objenesis.strategy.BaseInstantiatorStrategy;
import io.hops.hudi.org.objenesis.strategy.PlatformDescription;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine()) {
                if (Serializable.class.isAssignableFrom(type)) {
                    return new ObjectInputStreamInstantiator<T>(type);
                }
                return new AccessibleInstantiator<T>(type);
            }
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new UnsafeFactoryInstantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type);
            }
            return new Android18Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("BEA")) {
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

