/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.avro;

import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericData;
import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import io.hops.hudi.org.apache.avro.reflect.ReflectData;
import io.hops.hudi.org.apache.avro.specific.SpecificData;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBase;
import java.io.IOException;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.formats.parquet.ParquetBuilder;
import org.apache.flink.formats.parquet.ParquetWriterFactory;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.OutputFile;

@Experimental
public class AvroParquetWriters {
    public static <T extends SpecificRecordBase> ParquetWriterFactory<T> forSpecificRecord(Class<T> type) {
        String schemaString = SpecificData.get().getSchema(type).toString();
        ParquetBuilder builder = out -> AvroParquetWriters.createAvroParquetWriter(schemaString, SpecificData.get(), out);
        return new ParquetWriterFactory(builder);
    }

    public static ParquetWriterFactory<GenericRecord> forGenericRecord(Schema schema) {
        final String schemaString = schema.toString();
        ParquetBuilder<GenericRecord> builder = new ParquetBuilder<GenericRecord>(){

            @Override
            public ParquetWriter<GenericRecord> createWriter(OutputFile out) throws IOException {
                return AvroParquetWriters.createAvroParquetWriter(schemaString, GenericData.get(), out);
            }
        };
        return new ParquetWriterFactory<GenericRecord>(builder);
    }

    public static <T> ParquetWriterFactory<T> forReflectRecord(Class<T> type) {
        String schemaString = ReflectData.get().getSchema(type).toString();
        ParquetBuilder builder = out -> AvroParquetWriters.createAvroParquetWriter(schemaString, ReflectData.get(), out);
        return new ParquetWriterFactory(builder);
    }

    private static <T> ParquetWriter<T> createAvroParquetWriter(String schemaString, GenericData dataModel, OutputFile out) throws IOException {
        Schema schema = new Schema.Parser().parse(schemaString);
        return AvroParquetWriter.builder(out).withSchema(schema).withDataModel(dataModel).build();
    }

    private AvroParquetWriters() {
    }
}

