/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.formats.parquet.vector.ParquetDecimalVector;
import org.apache.flink.formats.parquet.vector.reader.BaseVectorizedColumnReader;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapArrayVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBooleanVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapByteVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapDoubleVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapFloatVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapIntVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapLongVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapShortVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapTimestampVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ArrayColumnReader
extends BaseVectorizedColumnReader {
    private Object lastValue;
    private boolean eof = false;
    boolean isFirstRow = true;

    public ArrayColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean isUtcTimestamp, Type type, LogicalType logicalType) throws IOException {
        super(descriptor, pageReader, isUtcTimestamp, type, logicalType);
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) {
        HeapArrayVector lcv = (HeapArrayVector)vector;
        lcv.setOffsets(new long[2048]);
        lcv.setLengths(new long[2048]);
        LogicalType elementType = ((ArrayType)this.logicalType).getElementType();
        if (this.isFirstRow) {
            if (!this.fetchNextValue(elementType)) {
                return;
            }
            this.isFirstRow = false;
        }
        ArrayList<Object> valueList = new ArrayList<Object>();
        int index = this.collectDataFromParquetPage(readNumber, lcv, valueList, elementType);
        this.fillColumnVector(elementType, lcv, valueList, index);
    }

    private boolean fetchNextValue(LogicalType type) {
        int left = this.readPageIfNeed();
        if (left > 0) {
            this.readRepetitionAndDefinitionLevels();
            this.lastValue = this.definitionLevel == this.maxDefLevel ? (this.isCurrentPageDictionaryEncoded ? Integer.valueOf(this.dataColumn.readValueDictionaryId()) : this.readPrimitiveTypedRow(type)) : null;
            return true;
        }
        this.eof = true;
        return false;
    }

    private int readPageIfNeed() {
        int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        if (leftInPage == 0) {
            this.readPage();
            leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        }
        return leftInPage;
    }

    private Object readPrimitiveTypedRow(LogicalType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dataColumn.readBytes();
            }
            case BOOLEAN: {
                return this.dataColumn.readBoolean();
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dataColumn.readInteger();
            }
            case TINYINT: {
                return this.dataColumn.readTinyInt();
            }
            case SMALLINT: {
                return this.dataColumn.readSmallInt();
            }
            case BIGINT: {
                return this.dataColumn.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.dataColumn.readFloat());
            }
            case DOUBLE: {
                return this.dataColumn.readDouble();
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dataColumn.readInteger();
                    }
                    case INT64: {
                        return this.dataColumn.readLong();
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dataColumn.readBytes();
                    }
                }
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.dataColumn.readTimestamp();
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + type);
    }

    private Object dictionaryDecodeValue(LogicalType type, Integer dictionaryValue) {
        if (dictionaryValue == null) {
            return null;
        }
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.dictionary.readBytes(dictionaryValue);
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                return this.dictionary.readInteger(dictionaryValue);
            }
            case BOOLEAN: {
                return this.dictionary.readBoolean(dictionaryValue) ? 1 : 0;
            }
            case DOUBLE: {
                return this.dictionary.readDouble(dictionaryValue);
            }
            case FLOAT: {
                return Float.valueOf(this.dictionary.readFloat(dictionaryValue));
            }
            case TINYINT: {
                return this.dictionary.readTinyInt(dictionaryValue);
            }
            case SMALLINT: {
                return this.dictionary.readSmallInt(dictionaryValue);
            }
            case BIGINT: {
                return this.dictionary.readLong(dictionaryValue);
            }
            case DECIMAL: {
                switch (this.descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return this.dictionary.readInteger(dictionaryValue);
                    }
                    case INT64: {
                        return this.dictionary.readLong(dictionaryValue);
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        return this.dictionary.readBytes(dictionaryValue);
                    }
                }
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.dictionary.readTimestamp(dictionaryValue);
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + type);
    }

    private int collectDataFromParquetPage(int total, HeapArrayVector lcv, List<Object> valueList, LogicalType type) {
        int index;
        for (index = 0; !this.eof && index < total; ++index) {
            lcv.getOffsets()[index] = valueList.size();
            do {
                if (this.definitionLevel == 0) {
                    lcv.setNullAt(index);
                }
                valueList.add(this.isCurrentPageDictionaryEncoded ? this.dictionaryDecodeValue(type, (Integer)this.lastValue) : this.lastValue);
            } while (this.fetchNextValue(type) && this.repetitionLevel != 0);
            lcv.getLengths()[index] = (long)valueList.size() - lcv.getOffsets()[index];
        }
        return index;
    }

    private void setChildrenInfo(HeapArrayVector lcv, int itemNum, int elementNum) {
        lcv.setSize(itemNum);
        long[] lcvLength = new long[elementNum];
        long[] lcvOffset = new long[elementNum];
        System.arraycopy(lcv.getLengths(), 0, lcvLength, 0, elementNum);
        System.arraycopy(lcv.getOffsets(), 0, lcvOffset, 0, elementNum);
        lcv.setLengths(lcvLength);
        lcv.setOffsets(lcvOffset);
    }

    private void fillColumnVector(LogicalType type, HeapArrayVector lcv, List valueList, int elementNum) {
        int total = valueList.size();
        this.setChildrenInfo(lcv, total, elementNum);
        block0 : switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                HeapBytesVector bytesVector = new HeapBytesVector(total);
                bytesVector.reset();
                lcv.setChild((ColumnVector)bytesVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    byte[] src = (byte[])valueList.get(i);
                    if (src == null) {
                        ((HeapBytesVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapBytesVector)lcv.getChild()).appendBytes(i, src, 0, src.length);
                }
                break;
            }
            case BOOLEAN: {
                HeapBooleanVector booleanVector = new HeapBooleanVector(total);
                booleanVector.reset();
                lcv.setChild((ColumnVector)booleanVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapBooleanVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapBooleanVector)lcv.getChild()).vector[i] = (Boolean)valueList.get(i);
                }
                break;
            }
            case TINYINT: {
                HeapByteVector byteVector = new HeapByteVector(total);
                byteVector.reset();
                lcv.setChild((ColumnVector)byteVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapByteVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapByteVector)lcv.getChild()).vector[i] = ((Integer)valueList.get(i)).byteValue();
                }
                break;
            }
            case SMALLINT: {
                HeapShortVector shortVector = new HeapShortVector(total);
                shortVector.reset();
                lcv.setChild((ColumnVector)shortVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapShortVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapShortVector)lcv.getChild()).vector[i] = ((Integer)valueList.get(i)).shortValue();
                }
                break;
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case INTEGER: {
                HeapIntVector intVector = new HeapIntVector(total);
                intVector.reset();
                lcv.setChild((ColumnVector)intVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapIntVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapIntVector)lcv.getChild()).vector[i] = (Integer)valueList.get(i);
                }
                break;
            }
            case FLOAT: {
                HeapFloatVector floatVector = new HeapFloatVector(total);
                floatVector.reset();
                lcv.setChild((ColumnVector)floatVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapFloatVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapFloatVector)lcv.getChild()).vector[i] = ((Float)valueList.get(i)).floatValue();
                }
                break;
            }
            case BIGINT: {
                HeapLongVector longVector = new HeapLongVector(total);
                longVector.reset();
                lcv.setChild((ColumnVector)longVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapLongVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapLongVector)lcv.getChild()).vector[i] = (Long)valueList.get(i);
                }
                break;
            }
            case DOUBLE: {
                HeapDoubleVector doubleVector = new HeapDoubleVector(total);
                doubleVector.reset();
                lcv.setChild((ColumnVector)doubleVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapDoubleVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapDoubleVector)lcv.getChild()).vector[i] = (Double)valueList.get(i);
                }
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                HeapTimestampVector timestampVector = new HeapTimestampVector(total);
                timestampVector.reset();
                lcv.setChild((ColumnVector)timestampVector);
                for (int i = 0; i < valueList.size(); ++i) {
                    if (valueList.get(i) == null) {
                        ((HeapTimestampVector)lcv.getChild()).setNullAt(i);
                        continue;
                    }
                    ((HeapTimestampVector)lcv.getChild()).setTimestamp(i, (TimestampData)valueList.get(i));
                }
                break;
            }
            case DECIMAL: {
                PrimitiveType.PrimitiveTypeName primitiveTypeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
                switch (primitiveTypeName) {
                    case INT32: {
                        HeapIntVector heapIntVector = new HeapIntVector(total);
                        heapIntVector.reset();
                        lcv.setChild((ColumnVector)new ParquetDecimalVector((ColumnVector)heapIntVector));
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                ((HeapIntVector)((ParquetDecimalVector)lcv.getChild()).getVector()).setNullAt(i);
                                continue;
                            }
                            ((HeapIntVector)((ParquetDecimalVector)lcv.getChild()).getVector()).vector[i] = (Integer)valueList.get(i);
                        }
                        break block0;
                    }
                    case INT64: {
                        HeapLongVector heapLongVector = new HeapLongVector(total);
                        heapLongVector.reset();
                        lcv.setChild((ColumnVector)new ParquetDecimalVector((ColumnVector)heapLongVector));
                        for (int i = 0; i < valueList.size(); ++i) {
                            if (valueList.get(i) == null) {
                                ((HeapLongVector)((ParquetDecimalVector)lcv.getChild()).getVector()).setNullAt(i);
                                continue;
                            }
                            ((HeapLongVector)((ParquetDecimalVector)lcv.getChild()).getVector()).vector[i] = (Long)valueList.get(i);
                        }
                        break block0;
                    }
                    default: {
                        HeapBytesVector heapBytesVector = new HeapBytesVector(total);
                        heapBytesVector.reset();
                        lcv.setChild((ColumnVector)new ParquetDecimalVector((ColumnVector)heapBytesVector));
                        for (int i = 0; i < valueList.size(); ++i) {
                            byte[] src = (byte[])valueList.get(i);
                            if (valueList.get(i) == null) {
                                ((HeapBytesVector)((ParquetDecimalVector)lcv.getChild()).getVector()).setNullAt(i);
                                continue;
                            }
                            ((HeapBytesVector)((ParquetDecimalVector)lcv.getChild()).getVector()).appendBytes(i, src, 0, src.length);
                        }
                        break block0;
                    }
                }
            }
            default: {
                throw new RuntimeException("Unsupported type in the list: " + type);
            }
        }
    }
}

