/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoopcompatibility.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopDummyReporter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.hadoopcompatibility.mapred.wrapper.HadoopOutputCollector;
import org.apache.flink.hadoopcompatibility.mapred.wrapper.HadoopTupleUnwrappingIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

@Public
public final class HadoopReduceCombineFunction<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends RichGroupReduceFunction<Tuple2<KEYIN, VALUEIN>, Tuple2<KEYOUT, VALUEOUT>>
implements GroupCombineFunction<Tuple2<KEYIN, VALUEIN>, Tuple2<KEYIN, VALUEIN>>,
ResultTypeQueryable<Tuple2<KEYOUT, VALUEOUT>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> reducer;
    private transient Reducer<KEYIN, VALUEIN, KEYIN, VALUEIN> combiner;
    private transient JobConf jobConf;
    private transient HadoopTupleUnwrappingIterator<KEYIN, VALUEIN> valueIterator;
    private transient HadoopOutputCollector<KEYOUT, VALUEOUT> reduceCollector;
    private transient HadoopOutputCollector<KEYIN, VALUEIN> combineCollector;
    private transient Reporter reporter;

    public HadoopReduceCombineFunction(Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> hadoopReducer, Reducer<KEYIN, VALUEIN, KEYIN, VALUEIN> hadoopCombiner) {
        this(hadoopReducer, hadoopCombiner, new JobConf());
    }

    public HadoopReduceCombineFunction(Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> hadoopReducer, Reducer<KEYIN, VALUEIN, KEYIN, VALUEIN> hadoopCombiner, JobConf conf) {
        if (hadoopReducer == null) {
            throw new NullPointerException("Reducer may not be null.");
        }
        if (hadoopCombiner == null) {
            throw new NullPointerException("Combiner may not be null.");
        }
        if (conf == null) {
            throw new NullPointerException("JobConf may not be null.");
        }
        this.reducer = hadoopReducer;
        this.combiner = hadoopCombiner;
        this.jobConf = conf;
    }

    @PublicEvolving
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.reducer.configure(this.jobConf);
        this.combiner.configure(this.jobConf);
        this.reporter = new HadoopDummyReporter();
        Class inKeyClass = (Class)TypeExtractor.getParameterType(Reducer.class, this.reducer.getClass(), (int)0);
        TypeSerializer keySerializer = this.getRuntimeContext().createSerializer(TypeExtractor.getForClass((Class)inKeyClass));
        this.valueIterator = new HadoopTupleUnwrappingIterator(keySerializer);
        this.combineCollector = new HadoopOutputCollector();
        this.reduceCollector = new HadoopOutputCollector();
    }

    public void reduce(Iterable<Tuple2<KEYIN, VALUEIN>> values2, Collector<Tuple2<KEYOUT, VALUEOUT>> out) throws Exception {
        this.reduceCollector.setFlinkCollector(out);
        this.valueIterator.set(values2.iterator());
        this.reducer.reduce(this.valueIterator.getCurrentKey(), this.valueIterator, this.reduceCollector, this.reporter);
    }

    public void combine(Iterable<Tuple2<KEYIN, VALUEIN>> values2, Collector<Tuple2<KEYIN, VALUEIN>> out) throws Exception {
        this.combineCollector.setFlinkCollector(out);
        this.valueIterator.set(values2.iterator());
        this.combiner.reduce(this.valueIterator.getCurrentKey(), this.valueIterator, this.combineCollector, this.reporter);
    }

    public TypeInformation<Tuple2<KEYOUT, VALUEOUT>> getProducedType() {
        Class outKeyClass = (Class)TypeExtractor.getParameterType(Reducer.class, this.reducer.getClass(), (int)2);
        Class outValClass = (Class)TypeExtractor.getParameterType(Reducer.class, this.reducer.getClass(), (int)3);
        TypeInformation keyTypeInfo = TypeExtractor.getForClass((Class)outKeyClass);
        TypeInformation valueTypleInfo = TypeExtractor.getForClass((Class)outValClass);
        return new TupleTypeInfo(new TypeInformation[]{keyTypeInfo, valueTypleInfo});
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.reducer.getClass());
        out.writeObject(this.combiner.getClass());
        this.jobConf.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class reducerClass = (Class)in.readObject();
        this.reducer = (Reducer)InstantiationUtil.instantiate((Class)reducerClass);
        Class combinerClass = (Class)in.readObject();
        this.combiner = (Reducer)InstantiationUtil.instantiate((Class)combinerClass);
        this.jobConf = new JobConf();
        this.jobConf.readFields((DataInput)in);
    }
}

