/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import io.hops.hudi.javax.servlet.http.HttpServlet;
import io.hops.hudi.javax.servlet.http.HttpServletRequest;
import io.hops.hudi.javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HMaster master = (HMaster)this.getServletContext().getAttribute("master");
        assert (master != null) : "No Master in context!";
        response.setContentType("text/html");
        Configuration conf = master.getConfiguration();
        Map<String, Integer> frags = this.getFragmentationInfo(master, conf);
        ServerName metaLocation = null;
        List<ServerName> servers = null;
        Set<ServerName> deadServers = null;
        if (master.isActiveMaster()) {
            metaLocation = this.getMetaLocationOrNull(master);
            ServerManager serverManager = master.getServerManager();
            if (serverManager != null) {
                deadServers = serverManager.getDeadServers().copyServerNames();
                servers = serverManager.getOnlineServersList();
            }
        }
        MasterStatusTmpl tmpl = new MasterStatusTmpl().setFrags(frags).setMetaLocation(metaLocation).setServers(servers).setDeadServers(deadServers).setCatalogJanitorEnabled(master.isCatalogJanitorEnabled());
        if (request.getParameter("filter") != null) {
            tmpl.setFilter(request.getParameter("filter"));
        }
        if (request.getParameter("format") != null) {
            tmpl.setFormat(request.getParameter("format"));
        }
        tmpl.render(response.getWriter(), master);
    }

    private ServerName getMetaLocationOrNull(HMaster master) {
        return MetaTableLocator.getMetaRegionLocation((ZKWatcher)master.getZooKeeper());
    }

    private Map<String, Integer> getFragmentationInfo(HMaster master, Configuration conf) throws IOException {
        boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
        if (showFragmentation) {
            return FSUtils.getTableFragmentation(master);
        }
        return null;
    }
}

