/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZKProcedureCoordinator
implements ProcedureCoordinatorRpcs {
    private static final Logger LOG = LoggerFactory.getLogger(ZKProcedureCoordinator.class);
    private ZKProcedureUtil zkProc = null;
    protected ProcedureCoordinator coordinator = null;
    ZKWatcher watcher;
    String procedureType;
    String coordName;

    public ZKProcedureCoordinator(ZKWatcher watcher, String procedureClass, String coordName) {
        this.watcher = watcher;
        this.procedureType = procedureClass;
        this.coordName = coordName;
    }

    @Override
    public final void sendGlobalBarrierAcquire(Procedure proc, byte[] info, List<String> nodeNames) throws IOException, IllegalArgumentException {
        String procName = proc.getName();
        String abortNode = this.zkProc.getAbortZNode(procName);
        try {
            if (ZKUtil.watchAndCheckExists((ZKWatcher)this.zkProc.getWatcher(), (String)abortNode)) {
                this.abort(abortNode);
            }
        }
        catch (KeeperException e) {
            String msg = "Failed while watching abort node:" + abortNode;
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        String acquire = this.zkProc.getAcquiredBarrierNode(procName);
        LOG.debug("Creating acquire znode:" + acquire);
        try {
            byte[] data = ProtobufUtil.prependPBMagic(info);
            ZKUtil.createWithParents((ZKWatcher)this.zkProc.getWatcher(), (String)acquire, (byte[])data);
            for (String node : nodeNames) {
                String znode = ZNodePaths.joinZNode(acquire, node);
                LOG.debug("Watching for acquire node:" + znode);
                if (!ZKUtil.watchAndCheckExists((ZKWatcher)this.zkProc.getWatcher(), (String)znode)) continue;
                this.coordinator.memberAcquiredBarrier(procName, node);
            }
        }
        catch (KeeperException e) {
            String msg = "Failed while creating acquire node:" + acquire;
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    @Override
    public void sendGlobalBarrierReached(Procedure proc, List<String> nodeNames) throws IOException {
        String procName = proc.getName();
        String reachedNode = this.zkProc.getReachedBarrierNode(procName);
        LOG.debug("Creating reached barrier zk node:" + reachedNode);
        try {
            ZKUtil.createWithParents((ZKWatcher)this.zkProc.getWatcher(), (String)reachedNode);
            for (String node : nodeNames) {
                String znode = ZNodePaths.joinZNode(reachedNode, node);
                if (!ZKUtil.watchAndCheckExists((ZKWatcher)this.zkProc.getWatcher(), (String)znode)) continue;
                byte[] dataFromMember = ZKUtil.getData((ZKWatcher)this.zkProc.getWatcher(), (String)znode);
                if (dataFromMember != null && dataFromMember.length > 0) {
                    if (!ProtobufUtil.isPBMagicPrefix(dataFromMember)) {
                        String msg = "Failed to get data from finished node or data is illegally formatted: " + znode;
                        LOG.error(msg);
                        throw new IOException(msg);
                    }
                    dataFromMember = Arrays.copyOfRange(dataFromMember, ProtobufUtil.lengthOfPBMagic(), dataFromMember.length);
                    this.coordinator.memberFinishedBarrier(procName, node, dataFromMember);
                    continue;
                }
                this.coordinator.memberFinishedBarrier(procName, node, dataFromMember);
            }
        }
        catch (KeeperException e) {
            String msg = "Failed while creating reached node:" + reachedNode;
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while creating reached node:" + reachedNode;
            LOG.error(msg, (Throwable)e);
            throw new InterruptedIOException(msg);
        }
    }

    @Override
    public final void resetMembers(Procedure proc) throws IOException {
        String procName = proc.getName();
        boolean stillGettingNotifications = false;
        do {
            try {
                LOG.debug("Attempting to clean out zk node for op:" + procName);
                this.zkProc.clearZNodes(procName);
                stillGettingNotifications = false;
            }
            catch (KeeperException.NotEmptyException e) {
                stillGettingNotifications = true;
            }
            catch (KeeperException e) {
                String msg = "Failed to complete reset procedure " + procName;
                LOG.error(msg, (Throwable)e);
                throw new IOException(msg, e);
            }
        } while (stillGettingNotifications);
    }

    @Override
    public final boolean start(final ProcedureCoordinator coordinator) {
        if (this.coordinator != null) {
            throw new IllegalStateException("ZKProcedureCoordinator already started and already has listener installed");
        }
        this.coordinator = coordinator;
        try {
            this.zkProc = new ZKProcedureUtil(this.watcher, this.procedureType){

                public void nodeCreated(String path) {
                    block13: {
                        if (!this.isInProcedurePath(path)) {
                            return;
                        }
                        LOG.debug("Node created: " + path);
                        this.logZKTree(this.baseZNode);
                        if (this.isAcquiredPathNode(path)) {
                            coordinator.memberAcquiredBarrier(ZKUtil.getNodeName((String)ZKUtil.getParent((String)path)), ZKUtil.getNodeName((String)path));
                        } else if (this.isReachedPathNode(path)) {
                            String procName = ZKUtil.getNodeName((String)ZKUtil.getParent((String)path));
                            String member = ZKUtil.getNodeName((String)path);
                            try {
                                byte[] dataFromMember = ZKUtil.getData((ZKWatcher)this.watcher, (String)path);
                                if (dataFromMember != null && dataFromMember.length > 0) {
                                    if (!ProtobufUtil.isPBMagicPrefix(dataFromMember)) {
                                        ForeignException ee = new ForeignException(ZKProcedureCoordinator.this.coordName, "Failed to get data from finished node or data is illegally formatted:" + path);
                                        coordinator.abortProcedure(procName, ee);
                                    } else {
                                        dataFromMember = Arrays.copyOfRange(dataFromMember, ProtobufUtil.lengthOfPBMagic(), dataFromMember.length);
                                        LOG.debug("Finished data from procedure '{}' member '{}': {}", new Object[]{procName, member, new String(dataFromMember, StandardCharsets.UTF_8)});
                                        coordinator.memberFinishedBarrier(procName, member, dataFromMember);
                                    }
                                    break block13;
                                }
                                coordinator.memberFinishedBarrier(procName, member, dataFromMember);
                            }
                            catch (KeeperException e) {
                                ForeignException ee = new ForeignException(ZKProcedureCoordinator.this.coordName, e);
                                coordinator.abortProcedure(procName, ee);
                            }
                            catch (InterruptedException e) {
                                ForeignException ee = new ForeignException(ZKProcedureCoordinator.this.coordName, e);
                                coordinator.abortProcedure(procName, ee);
                            }
                        } else if (this.isAbortPathNode(path)) {
                            ZKProcedureCoordinator.this.abort(path);
                        } else {
                            LOG.debug("Ignoring created notification for node:" + path);
                        }
                    }
                }
            };
            this.zkProc.clearChildZNodes();
        }
        catch (KeeperException e) {
            LOG.error("Unable to start the ZK-based Procedure Coordinator rpcs.", (Throwable)e);
            return false;
        }
        LOG.debug("Starting controller for procedure member=" + this.coordName);
        return true;
    }

    @Override
    public final void sendAbortToMembers(Procedure proc, ForeignException ee) {
        String procName = proc.getName();
        LOG.debug("Aborting procedure '" + procName + "' in zk");
        String procAbortNode = this.zkProc.getAbortZNode(procName);
        try {
            LOG.debug("Creating abort znode:" + procAbortNode);
            String source = ee.getSource() == null ? this.coordName : ee.getSource();
            byte[] errorInfo = ProtobufUtil.prependPBMagic(ForeignException.serialize(source, ee));
            ZKUtil.createAndFailSilent((ZKWatcher)this.zkProc.getWatcher(), (String)procAbortNode, (byte[])errorInfo);
            LOG.debug("Finished creating abort node:" + procAbortNode);
        }
        catch (KeeperException e) {
            this.zkProc.logZKTree(this.zkProc.baseZNode);
            this.coordinator.rpcConnectionFailure("Failed to post zk node:" + procAbortNode + " to abort procedure '" + procName + "'", new IOException(e));
        }
    }

    protected void abort(String abortNode) {
        String procName = ZKUtil.getNodeName((String)abortNode);
        ForeignException ee = null;
        try {
            byte[] data = ZKUtil.getData((ZKWatcher)this.zkProc.getWatcher(), (String)abortNode);
            if (data == null || data.length == 0) {
                return;
            }
            if (!ProtobufUtil.isPBMagicPrefix(data)) {
                LOG.warn("Got an error notification for op:" + abortNode + " but we can't read the information. Killing the procedure.");
                ee = new ForeignException(this.coordName, "Data in abort node is illegally formatted.  ignoring content.");
            } else {
                data = Arrays.copyOfRange(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                ee = ForeignException.deserialize(data);
            }
        }
        catch (IOException e) {
            LOG.warn("Got an error notification for op:" + abortNode + " but we can't read the information. Killing the procedure.");
            ee = new ForeignException(this.coordName, e);
        }
        catch (KeeperException e) {
            this.coordinator.rpcConnectionFailure("Failed to get data for abort node:" + abortNode + this.zkProc.getAbortZnode(), new IOException(e));
        }
        catch (InterruptedException e) {
            this.coordinator.rpcConnectionFailure("Failed to get data for abort node:" + abortNode + this.zkProc.getAbortZnode(), new IOException(e));
            Thread.currentThread().interrupt();
        }
        this.coordinator.abortProcedure(procName, ee);
    }

    @Override
    public final void close() throws IOException {
        this.zkProc.close();
    }

    final ZKProcedureUtil getZkProcedureUtil() {
        return this.zkProc;
    }
}

