/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import io.hops.hudi.org.apache.avro.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.avro.ConvertingGenericData;
import org.apache.hudi.avro.HoodieBloomFilterWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;

public class HoodieAvroWriteSupport<T>
extends AvroWriteSupport<T> {
    private final Option<HoodieBloomFilterWriteSupport<String>> bloomFilterWriteSupportOpt;
    private final Map<String, String> footerMetadata = new HashMap<String, String>();
    protected final Properties properties;

    public HoodieAvroWriteSupport(MessageType schema, Schema avroSchema, Option<BloomFilter> bloomFilterOpt, Properties properties) {
        super(schema, avroSchema, ConvertingGenericData.INSTANCE);
        this.bloomFilterWriteSupportOpt = bloomFilterOpt.map(HoodieBloomFilterAvroWriteSupport::new);
        this.properties = properties;
    }

    @Override
    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        HashMap<String, String> extraMetadata = CollectionUtils.combine(this.footerMetadata, this.bloomFilterWriteSupportOpt.map(HoodieBloomFilterWriteSupport::finalizeMetadata).orElse(Collections.emptyMap()));
        return new WriteSupport.FinalizedWriteContext(extraMetadata);
    }

    public void add(String recordKey) {
        this.bloomFilterWriteSupportOpt.ifPresent(bloomFilterWriteSupport -> bloomFilterWriteSupport.addKey(recordKey));
    }

    public void addFooterMetadata(String key, String value) {
        this.footerMetadata.put(key, value);
    }

    private static class HoodieBloomFilterAvroWriteSupport
    extends HoodieBloomFilterWriteSupport<String> {
        public HoodieBloomFilterAvroWriteSupport(BloomFilter bloomFilter) {
            super(bloomFilter);
        }

        @Override
        protected byte[] getUTF8Bytes(String key) {
            return StringUtils.getUTF8Bytes(key);
        }
    }
}

