/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import io.hops.hudi.org.apache.avro.AvroMissingFieldException;
import io.hops.hudi.org.apache.avro.AvroRuntimeException;
import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.data.RecordBuilder;
import io.hops.hudi.org.apache.avro.io.DatumReader;
import io.hops.hudi.org.apache.avro.io.DatumWriter;
import io.hops.hudi.org.apache.avro.io.Encoder;
import io.hops.hudi.org.apache.avro.io.ResolvingDecoder;
import io.hops.hudi.org.apache.avro.message.BinaryMessageDecoder;
import io.hops.hudi.org.apache.avro.message.BinaryMessageEncoder;
import io.hops.hudi.org.apache.avro.message.SchemaStore;
import io.hops.hudi.org.apache.avro.specific.AvroGenerated;
import io.hops.hudi.org.apache.avro.specific.SpecificData;
import io.hops.hudi.org.apache.avro.specific.SpecificRecord;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBase;
import io.hops.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;

@AvroGenerated
public class HoodieMetadataBloomFilter
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6105769873533293432L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieMetadataBloomFilter\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"Data file bloom filter details\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Bloom filter type code\"},{\"name\":\"timestamp\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Instant timestamp when this metadata was created/updated\"},{\"name\":\"bloomFilter\",\"type\":\"bytes\",\"doc\":\"Bloom filter binary byte array\"},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Bloom filter entry valid/deleted flag\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieMetadataBloomFilter> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieMetadataBloomFilter> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String type;
    private String timestamp;
    private ByteBuffer bloomFilter;
    private boolean isDeleted;
    private static final DatumWriter<HoodieMetadataBloomFilter> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieMetadataBloomFilter> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieMetadataBloomFilter> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieMetadataBloomFilter> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieMetadataBloomFilter> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder<HoodieMetadataBloomFilter>(MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieMetadataBloomFilter fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieMetadataBloomFilter)DECODER.decode(b);
    }

    public HoodieMetadataBloomFilter() {
    }

    public HoodieMetadataBloomFilter(String type, String timestamp, ByteBuffer bloomFilter, Boolean isDeleted) {
        this.type = type;
        this.timestamp = timestamp;
        this.bloomFilter = bloomFilter;
        this.isDeleted = isDeleted;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.type;
            }
            case 1: {
                return this.timestamp;
            }
            case 2: {
                return this.bloomFilter;
            }
            case 3: {
                return this.isDeleted;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.type = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.timestamp = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.bloomFilter = (ByteBuffer)value$;
                break;
            }
            case 3: {
                this.isDeleted = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String value) {
        this.timestamp = value;
    }

    public ByteBuffer getBloomFilter() {
        return this.bloomFilter;
    }

    public void setBloomFilter(ByteBuffer value) {
        this.bloomFilter = value;
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(boolean value) {
        this.isDeleted = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieMetadataBloomFilter other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.timestamp);
        out.writeBytes(this.bloomFilter);
        out.writeBoolean(this.isDeleted);
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.type = in.readString();
            this.timestamp = in.readString();
            this.bloomFilter = in.readBytes(this.bloomFilter);
            this.isDeleted = in.readBoolean();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.type = in.readString();
                        continue block6;
                    }
                    case 1: {
                        this.timestamp = in.readString();
                        continue block6;
                    }
                    case 2: {
                        this.bloomFilter = in.readBytes(this.bloomFilter);
                        continue block6;
                    }
                    case 3: {
                        this.isDeleted = in.readBoolean();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieMetadataBloomFilter>
    implements RecordBuilder<HoodieMetadataBloomFilter> {
        private String type;
        private String timestamp;
        private ByteBuffer bloomFilter;
        private boolean isDeleted;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.type)) {
                this.type = this.data().deepCopy(this.fields()[0].schema(), other.type);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.timestamp)) {
                this.timestamp = this.data().deepCopy(this.fields()[1].schema(), other.timestamp);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.bloomFilter)) {
                this.bloomFilter = this.data().deepCopy(this.fields()[2].schema(), other.bloomFilter);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.isDeleted)) {
                this.isDeleted = this.data().deepCopy(this.fields()[3].schema(), other.isDeleted);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(HoodieMetadataBloomFilter other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.type)) {
                this.type = this.data().deepCopy(this.fields()[0].schema(), other.type);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.timestamp)) {
                this.timestamp = this.data().deepCopy(this.fields()[1].schema(), other.timestamp);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.bloomFilter)) {
                this.bloomFilter = this.data().deepCopy(this.fields()[2].schema(), other.bloomFilter);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.isDeleted)) {
                this.isDeleted = this.data().deepCopy(this.fields()[3].schema(), other.isDeleted);
                this.fieldSetFlags()[3] = true;
            }
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String value) {
            this.validate(this.fields()[0], value);
            this.type = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(String value) {
            this.validate(this.fields()[1], value);
            this.timestamp = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimestamp() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimestamp() {
            this.timestamp = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public ByteBuffer getBloomFilter() {
            return this.bloomFilter;
        }

        public Builder setBloomFilter(ByteBuffer value) {
            this.validate(this.fields()[2], value);
            this.bloomFilter = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasBloomFilter() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearBloomFilter() {
            this.bloomFilter = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getIsDeleted() {
            return this.isDeleted;
        }

        public Builder setIsDeleted(boolean value) {
            this.validate(this.fields()[3], value);
            this.isDeleted = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasIsDeleted() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearIsDeleted() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        @Override
        public HoodieMetadataBloomFilter build() {
            try {
                HoodieMetadataBloomFilter record = new HoodieMetadataBloomFilter();
                record.type = this.fieldSetFlags()[0] ? this.type : (String)this.defaultValue(this.fields()[0]);
                record.timestamp = this.fieldSetFlags()[1] ? this.timestamp : (String)this.defaultValue(this.fields()[1]);
                record.bloomFilter = this.fieldSetFlags()[2] ? this.bloomFilter : (ByteBuffer)this.defaultValue(this.fields()[2]);
                record.isDeleted = this.fieldSetFlags()[3] ? this.isDeleted : (Boolean)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

