/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.models;

import io.hops.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import io.hops.hudi.com.fasterxml.jackson.databind.DeserializationFeature;
import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hudi.client.transaction.lock.models.StorageLockData;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;

public class StorageLockFile {
    private final StorageLockData data;
    private final String versionId;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);

    public StorageLockFile(StorageLockData data, String versionId) {
        ValidationUtils.checkArgument(data != null, "Data must not be null.");
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(versionId), "VersionId must not be null or empty.");
        this.data = data;
        this.versionId = versionId;
    }

    public static StorageLockFile createFromStream(InputStream inputStream, String versionId) {
        try {
            StorageLockData data = OBJECT_MAPPER.readValue(inputStream, StorageLockData.class);
            return new StorageLockFile(data, versionId);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize JSON content into StorageLockData", e);
        }
    }

    public void writeToStream(OutputStream outputStream) {
        try {
            OBJECT_MAPPER.writeValue(outputStream, (Object)this.data);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error writing object to JSON output stream", e);
        }
    }

    public static byte[] toByteArray(StorageLockData data) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new HoodieIOException("Error writing object to byte array", e);
        }
    }

    public String getVersionId() {
        return this.versionId;
    }

    public long getValidUntilMs() {
        return this.data.getValidUntil();
    }

    public boolean isExpired() {
        return this.data.isExpired();
    }

    public String getOwner() {
        return this.data.getOwner();
    }
}

