/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import io.hops.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieLSMTimelineManifest
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieLSMTimelineManifest.class);
    public static final HoodieLSMTimelineManifest EMPTY = new HoodieLSMTimelineManifest();
    private final List<LSMFileEntry> files;

    public HoodieLSMTimelineManifest() {
        this.files = new ArrayList<LSMFileEntry>();
    }

    public HoodieLSMTimelineManifest(List<LSMFileEntry> files) {
        this.files = files;
    }

    public void addFile(String fileName, long fileLen) {
        this.files.add(LSMFileEntry.getInstance(fileName, fileLen));
    }

    public void addFile(LSMFileEntry fileEntry) {
        this.files.add(fileEntry);
    }

    public List<LSMFileEntry> getFiles() {
        return this.files;
    }

    public List<String> getFileNames() {
        return this.files.stream().map(LSMFileEntry::getFileName).collect(Collectors.toList());
    }

    public String toJsonString() throws IOException {
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    public HoodieLSMTimelineManifest copy(List<String> filesToRemove) {
        if (filesToRemove.isEmpty()) {
            return new HoodieLSMTimelineManifest(new ArrayList<LSMFileEntry>(this.files));
        }
        List<LSMFileEntry> newFiles = this.files.stream().filter(fileEntry -> !filesToRemove.contains(fileEntry.getFileName())).collect(Collectors.toList());
        return new HoodieLSMTimelineManifest(newFiles);
    }

    public static class LSMFileEntry
    implements Serializable,
    Comparable<LSMFileEntry> {
        private String fileName;
        private long fileLen;

        public LSMFileEntry() {
        }

        private LSMFileEntry(String fileName, long fileLen) {
            this.fileName = fileName;
            this.fileLen = fileLen;
        }

        public static LSMFileEntry getInstance(String fileName, long fileLen) {
            return new LSMFileEntry(fileName, fileLen);
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileLen() {
            return this.fileLen;
        }

        @Override
        public int compareTo(LSMFileEntry other) {
            return this.fileName.compareTo(other.fileName);
        }
    }
}

