/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.KryoSerializable;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;

public class HoodieRecordDelegate
implements Serializable,
KryoSerializable {
    private HoodieKey hoodieKey;
    private Option<HoodieRecordLocation> currentLocation;
    private Option<HoodieRecordLocation> newLocation;
    private boolean ignoreIndexUpdate;

    private HoodieRecordDelegate(HoodieKey hoodieKey, @Nullable HoodieRecordLocation currentLocation, @Nullable HoodieRecordLocation newLocation, boolean ignoreIndexUpdate) {
        this.hoodieKey = hoodieKey;
        this.currentLocation = Option.ofNullable(currentLocation);
        this.newLocation = Option.ofNullable(newLocation);
        this.ignoreIndexUpdate = ignoreIndexUpdate;
    }

    public static HoodieRecordDelegate create(String recordKey, String partitionPath) {
        return new HoodieRecordDelegate(new HoodieKey(recordKey, partitionPath), null, null, false);
    }

    public static HoodieRecordDelegate create(String recordKey, String partitionPath, HoodieRecordLocation currentLocation) {
        return new HoodieRecordDelegate(new HoodieKey(recordKey, partitionPath), currentLocation, null, false);
    }

    public static HoodieRecordDelegate create(String recordKey, String partitionPath, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        return new HoodieRecordDelegate(new HoodieKey(recordKey, partitionPath), currentLocation, newLocation, false);
    }

    public static HoodieRecordDelegate create(HoodieKey key) {
        return new HoodieRecordDelegate(key, null, null, false);
    }

    public static HoodieRecordDelegate create(HoodieKey key, HoodieRecordLocation currentLocation) {
        return new HoodieRecordDelegate(key, currentLocation, null, false);
    }

    public static HoodieRecordDelegate create(HoodieKey key, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        return new HoodieRecordDelegate(key, currentLocation, newLocation, false);
    }

    public static HoodieRecordDelegate fromHoodieRecord(HoodieRecord record) {
        return new HoodieRecordDelegate(record.getKey(), record.getCurrentLocation(), record.getNewLocation(), record.getIgnoreIndexUpdate());
    }

    public static HoodieRecordDelegate fromHoodieRecord(HoodieRecord record, @Nullable HoodieRecordLocation newLocationOverride) {
        return new HoodieRecordDelegate(record.getKey(), record.getCurrentLocation(), newLocationOverride, record.getIgnoreIndexUpdate());
    }

    public String getRecordKey() {
        return this.hoodieKey.getRecordKey();
    }

    public String getPartitionPath() {
        return this.hoodieKey.getPartitionPath();
    }

    public HoodieKey getHoodieKey() {
        return this.hoodieKey;
    }

    public Option<HoodieRecordLocation> getCurrentLocation() {
        return this.currentLocation;
    }

    public Option<HoodieRecordLocation> getNewLocation() {
        return this.newLocation;
    }

    public boolean getIgnoreIndexUpdate() {
        return this.ignoreIndexUpdate;
    }

    public String toString() {
        return "HoodieRecordDelegate{hoodieKey=" + this.hoodieKey + ", currentLocation=" + this.currentLocation + ", newLocation=" + this.newLocation + ", ignoreIndexUpdate=" + this.ignoreIndexUpdate + '}';
    }

    @Override
    @VisibleForTesting
    public final void write(Kryo kryo, Output output) {
        kryo.writeObjectOrNull(output, (Object)this.hoodieKey, HoodieKey.class);
        kryo.writeClassAndObject(output, this.currentLocation.isPresent() ? this.currentLocation.get() : null);
        kryo.writeClassAndObject(output, this.newLocation.isPresent() ? this.newLocation.get() : null);
        kryo.writeObjectOrNull(output, (Object)this.ignoreIndexUpdate, Boolean.class);
    }

    @Override
    @VisibleForTesting
    public final void read(Kryo kryo, Input input) {
        this.hoodieKey = kryo.readObjectOrNull(input, HoodieKey.class);
        this.currentLocation = Option.ofNullable((HoodieRecordLocation)kryo.readClassAndObject(input));
        this.newLocation = Option.ofNullable((HoodieRecordLocation)kryo.readClassAndObject(input));
        this.ignoreIndexUpdate = kryo.readObjectOrNull(input, Boolean.class);
    }
}

