/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;

public class KeyBasedFileGroupRecordBuffer<T>
extends FileGroupRecordBuffer<T> {
    public KeyBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partitionNameOverrideOpt, partitionPathFieldOpt, props, readStats);
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.KEY_BASED_MERGE;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        Pair recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        if (dataBlock.containsPartialUpdates()) {
            this.enablePartialMerging = true;
        }
        Schema schema = AvroSchemaCache.intern(recordsIteratorSchemaPair.getRight());
        try (ClosableIterator recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                boolean isDelete = this.isBuiltInDeleteRecord(nextRecord) || this.isCustomDeleteRecord(nextRecord);
                BufferedRecord bufferedRecord = BufferedRecord.forRecordWithContext(nextRecord, schema, this.readerContext, this.orderingFieldName, isDelete);
                this.processNextDataRecord(bufferedRecord, (Serializable)((Object)bufferedRecord.getRecordKey()));
            }
        }
    }

    @Override
    public void processNextDataRecord(BufferedRecord<T> record, Serializable recordKey) throws IOException {
        BufferedRecord existingRecord = (BufferedRecord)this.records.get(recordKey);
        Option<BufferedRecord<T>> bufferRecord = this.doProcessNextDataRecord(record, existingRecord);
        if (bufferRecord.isPresent()) {
            this.records.put(recordKey, bufferRecord.get().toBinary(this.readerContext));
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            this.processNextDeletedRecord(record, (Serializable)((Object)record.getRecordKey()));
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable recordKey) {
        BufferedRecord existingRecord = (BufferedRecord)this.records.get(recordKey);
        Option<DeleteRecord> recordOpt = this.doProcessNextDeletedRecord(deleteRecord, existingRecord);
        if (recordOpt.isPresent()) {
            Comparable orderingValue = KeyBasedFileGroupRecordBuffer.getOrderingValue(this.readerContext, recordOpt.get());
            this.records.put(recordKey, BufferedRecord.forDeleteRecord(deleteRecord, orderingValue));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.containsKey(recordKey);
    }

    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        String recordKey = this.readerContext.getRecordKey(baseRecord, this.readerSchema);
        BufferedRecord logRecordInfo = (BufferedRecord)this.records.remove(recordKey);
        return this.hasNextBaseRecord(baseRecord, logRecordInfo);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState(this.baseFileIterator != null, "Base file iterator has not been set yet");
        while (this.baseFileIterator.hasNext()) {
            if (!this.hasNextBaseRecord(this.baseFileIterator.next())) continue;
            return true;
        }
        return this.hasNextLogRecord();
    }
}

