/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import io.hops.hudi.org.apache.avro.specific.SpecificRecordBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BooleanSupplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitMetadataSerDeV1
implements CommitMetadataSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(CommitMetadataSerDeV1.class);

    @Override
    public <T> T deserialize(HoodieInstant instant, InputStream inputStream, BooleanSupplier isEmptyInstant, Class<T> clazz) throws IOException {
        try {
            if (HoodieCommitMetadata.class.isAssignableFrom(clazz)) {
                return JsonUtils.getObjectMapper().readValue(inputStream, clazz);
            }
            if (!SpecificRecordBase.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class must extend SpecificRecordBase: " + clazz.getName());
            }
            Class<T> avroClass = clazz;
            return TimelineMetadataUtils.deserializeAvroMetadata(inputStream, avroClass);
        }
        catch (Exception e) {
            if (isEmptyInstant.getAsBoolean()) {
                try {
                    return clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new IOException("unable to read commit metadata for instant " + instant, ex);
                }
            }
            throw new IOException("Unable to read commit metadata for instant " + instant, e);
        }
    }

    @Override
    public <T> Option<HoodieInstantWriter> getInstantWriter(T metadata) {
        MetadataConversionUtils.removeNullKeyFromMapMembersForCommitMetadata(metadata);
        if (metadata instanceof HoodieReplaceCommitMetadata) {
            return Option.of(outputStream -> JsonUtils.getObjectMapper().writerFor(HoodieReplaceCommitMetadata.class).withDefaultPrettyPrinter().writeValue(outputStream, metadata));
        }
        if (metadata instanceof HoodieCommitMetadata) {
            return Option.of(outputStream -> JsonUtils.getObjectMapper().writerFor(HoodieCommitMetadata.class).withDefaultPrettyPrinter().writeValue(outputStream, metadata));
        }
        SpecificRecordBase avroMetadata = (SpecificRecordBase)metadata;
        return CommitMetadataSerDe.getInstantWriter(Option.of(avroMetadata));
    }
}

