/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import io.hops.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import io.hops.hudi.com.fasterxml.jackson.core.type.TypeReference;
import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.timeline.dto.ClusteringOpDTO;
import org.apache.hudi.common.table.timeline.dto.CompactionOpDTO;
import org.apache.hudi.common.table.timeline.dto.DTOUtils;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;
import org.apache.hudi.common.table.timeline.dto.TimelineDTO;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieRemoteException;
import org.apache.hudi.timeline.TimelineServiceClient;
import org.apache.hudi.timeline.TimelineServiceClientBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHoodieTableFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new AfterburnerModule());
    private static final String SCHEME = "http";
    private static final String BASE_URL = "/v1/hoodie/view";
    public static final String LATEST_PARTITION_SLICES_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/partition/latest/");
    public static final String LATEST_PARTITION_SLICES_INFLIGHT_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/partition/latest/inflight/");
    public static final String LATEST_PARTITION_SLICES_STATELESS_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/partition/latest/stateless/");
    public static final String LATEST_PARTITION_SLICE_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/file/latest/");
    public static final String LATEST_PARTITION_UNCOMPACTED_SLICES_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/uncompacted/partition/latest/");
    public static final String ALL_SLICES_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/all");
    public static final String LATEST_SLICES_MERGED_BEFORE_ON_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/merged/beforeoron/latest/");
    public static final String LATEST_SLICES_RANGE_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/range/latest/");
    public static final String LATEST_SLICES_BEFORE_ON_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/beforeoron/latest/");
    public static final String ALL_LATEST_SLICES_BEFORE_ON_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "slices/all/beforeoron/latest/");
    public static final String PENDING_COMPACTION_OPS_URL = String.format("%s/%s", "/v1/hoodie/view", "compactions/pending/");
    public static final String PENDING_LOG_COMPACTION_OPS_URL = String.format("%s/%s", "/v1/hoodie/view", "logcompactions/pending/");
    public static final String LATEST_PARTITION_DATA_FILES_URL = String.format("%s/%s", "/v1/hoodie/view", "datafiles/latest/partition");
    public static final String LATEST_PARTITION_DATA_FILE_URL = String.format("%s/%s", "/v1/hoodie/view", "datafile/latest/partition");
    public static final String ALL_DATA_FILES_URL = String.format("%s/%s", "/v1/hoodie/view", "datafiles/all");
    public static final String LATEST_ALL_DATA_FILES_URL = String.format("%s/%s", "/v1/hoodie/view", "datafiles/all/latest/");
    public static final String LATEST_DATA_FILE_ON_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "datafile/on/latest/");
    public static final String LATEST_DATA_FILES_RANGE_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "datafiles/range/latest/");
    public static final String LATEST_DATA_FILES_BEFORE_ON_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "datafiles/beforeoron/latest/");
    public static final String ALL_LATEST_BASE_FILES_BEFORE_ON_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "basefiles/all/beforeoron/");
    public static final String ALL_FILEGROUPS_FOR_PARTITION_URL = String.format("%s/%s", "/v1/hoodie/view", "filegroups/all/partition/");
    public static final String ALL_FILEGROUPS_FOR_PARTITION_STATELESS_URL = String.format("%s/%s", "/v1/hoodie/view", "filegroups/all/partition/stateless/");
    public static final String ALL_REPLACED_FILEGROUPS_BEFORE_OR_ON_URL = String.format("%s/%s", "/v1/hoodie/view", "filegroups/replaced/beforeoron/");
    public static final String ALL_REPLACED_FILEGROUPS_BEFORE_URL = String.format("%s/%s", "/v1/hoodie/view", "filegroups/replaced/before/");
    public static final String ALL_REPLACED_FILEGROUPS_AFTER_OR_ON_URL = String.format("%s/%s", "/v1/hoodie/view", "filegroups/replaced/afteroron/");
    public static final String ALL_REPLACED_FILEGROUPS_PARTITION_URL = String.format("%s/%s", "/v1/hoodie/view", "filegroups/replaced/partition/");
    public static final String PENDING_CLUSTERING_FILEGROUPS_URL = String.format("%s/%s", "/v1/hoodie/view", "clustering/pending/");
    public static final String LAST_INSTANT_URL = String.format("%s/%s", "/v1/hoodie/view", "timeline/instant/last");
    public static final String LAST_INSTANTS_URL = String.format("%s/%s", "/v1/hoodie/view", "timeline/instants/last");
    public static final String TIMELINE_URL = String.format("%s/%s", "/v1/hoodie/view", "timeline/instants/all");
    public static final String REFRESH_TABLE_URL = String.format("%s/%s", "/v1/hoodie/view", "refresh/");
    public static final String LOAD_ALL_PARTITIONS_URL = String.format("%s/%s", "/v1/hoodie/view", "loadallpartitions/");
    public static final String LOAD_PARTITIONS_URL = String.format("%s/%s", "/v1/hoodie/view", "loadpartitions/");
    public static final String PARTITION_PARAM = "partition";
    public static final String PARTITIONS_PARAM = "partitions";
    public static final String BASEPATH_PARAM = "basepath";
    public static final String INSTANT_PARAM = "instant";
    public static final String MAX_INSTANT_PARAM = "maxinstant";
    public static final String MIN_INSTANT_PARAM = "mininstant";
    public static final String INSTANTS_PARAM = "instants";
    public static final String FILEID_PARAM = "fileid";
    public static final String LAST_INSTANT_TS = "lastinstantts";
    public static final String TIMELINE_HASH = "timelinehash";
    public static final String REFRESH_OFF = "refreshoff";
    public static final String INCLUDE_FILES_IN_PENDING_COMPACTION_PARAM = "includependingcompaction";
    public static final String MULTI_VALUE_SEPARATOR = ",";
    private static final Logger LOG = LoggerFactory.getLogger(RemoteHoodieTableFileSystemView.class);
    private static final TypeReference<List<FileSliceDTO>> FILE_SLICE_DTOS_REFERENCE = new TypeReference<List<FileSliceDTO>>(){};
    private static final TypeReference<List<FileGroupDTO>> FILE_GROUP_DTOS_REFERENCE = new TypeReference<List<FileGroupDTO>>(){};
    private static final TypeReference<Boolean> BOOLEAN_TYPE_REFERENCE = new TypeReference<Boolean>(){};
    private static final TypeReference<List<CompactionOpDTO>> COMPACTION_OP_DTOS_REFERENCE = new TypeReference<List<CompactionOpDTO>>(){};
    private static final TypeReference<List<ClusteringOpDTO>> CLUSTERING_OP_DTOS_REFERENCE = new TypeReference<List<ClusteringOpDTO>>(){};
    private static final TypeReference<List<InstantDTO>> INSTANT_DTOS_REFERENCE = new TypeReference<List<InstantDTO>>(){};
    private static final TypeReference<TimelineDTO> TIMELINE_DTO_REFERENCE = new TypeReference<TimelineDTO>(){};
    private static final TypeReference<List<BaseFileDTO>> BASE_FILE_DTOS_REFERENCE = new TypeReference<List<BaseFileDTO>>(){};
    private static final TypeReference<Map<String, List<BaseFileDTO>>> BASE_FILE_MAP_REFERENCE = new TypeReference<Map<String, List<BaseFileDTO>>>(){};
    private static final TypeReference<Map<String, List<FileSliceDTO>>> FILE_SLICE_MAP_REFERENCE = new TypeReference<Map<String, List<FileSliceDTO>>>(){};
    private final String basePath;
    private final HoodieTableMetaClient metaClient;
    private HoodieTimeline timeline;
    private final TimelineServiceClientBase timelineServiceClient;
    private boolean closed = false;

    public RemoteHoodieTableFileSystemView(String server, int port, HoodieTableMetaClient metaClient) {
        this(metaClient, FileSystemViewStorageConfig.newBuilder().withRemoteServerHost(server).withRemoteServerPort(port).build());
    }

    public RemoteHoodieTableFileSystemView(HoodieTableMetaClient metaClient, FileSystemViewStorageConfig viewConf) {
        this.basePath = metaClient.getBasePath().toString();
        this.metaClient = metaClient;
        this.timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        this.timelineServiceClient = new TimelineServiceClient(viewConf);
    }

    private <T> T executeRequest(String requestPath, Map<String, String> queryParameters, TypeReference<T> reference, TimelineServiceClientBase.RequestMethod method) throws IOException {
        ValidationUtils.checkArgument(!this.closed, "View already closed");
        this.timeline.lastInstant().ifPresent(instant -> queryParameters.put(LAST_INSTANT_TS, instant.requestedTime()));
        queryParameters.put(TIMELINE_HASH, this.timeline.getTimelineHash());
        return this.timelineServiceClient.makeRequest(TimelineServiceClientBase.Request.newBuilder(method, requestPath).addQueryParams(queryParameters).build()).getDecodedContent(reference);
    }

    private Map<String, String> getParamsWithPartitionPath(String partitionPath) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        paramsMap.put(PARTITION_PARAM, partitionPath);
        return paramsMap;
    }

    private Map<String, String> getParams() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        return paramsMap;
    }

    private Map<String, String> getParams(String paramName, String instant) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        paramsMap.put(paramName, instant);
        return paramsMap;
    }

    private Map<String, String> getParamsWithAdditionalParam(String partitionPath, String paramName, String paramVal) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        paramsMap.put(PARTITION_PARAM, partitionPath);
        paramsMap.put(paramName, paramVal);
        return paramsMap;
    }

    private Map<String, String> getParamsWithAdditionalParams(String partitionPath, String[] paramNames, String[] paramVals) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        paramsMap.put(PARTITION_PARAM, partitionPath);
        ValidationUtils.checkArgument(paramNames.length == paramVals.length);
        for (int i = 0; i < paramNames.length; ++i) {
            paramsMap.put(paramNames[i], paramVals[i]);
        }
        return paramsMap;
    }

    private Stream<HoodieBaseFile> getLatestBaseFilesFromParams(String requestPath, Map<String, String> paramsMap) {
        try {
            List<BaseFileDTO> dataFiles = this.executeRequest(requestPath, paramsMap, BASE_FILE_DTOS_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return dataFiles.stream().map(BaseFileDTO::toHoodieBaseFile);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFiles(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestBaseFilesFromParams(LATEST_PARTITION_DATA_FILES_URL, paramsMap);
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFiles() {
        Map<String, String> paramsMap = this.getParams();
        return this.getLatestBaseFilesFromParams(LATEST_ALL_DATA_FILES_URL, paramsMap);
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String partitionPath, String maxCommitTime) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, MAX_INSTANT_PARAM, maxCommitTime);
        return this.getLatestBaseFilesFromParams(LATEST_DATA_FILES_BEFORE_ON_INSTANT_URL, paramsMap);
    }

    @Override
    public Map<String, Stream<HoodieBaseFile>> getAllLatestBaseFilesBeforeOrOn(String maxCommitTime) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        paramsMap.put(MAX_INSTANT_PARAM, maxCommitTime);
        try {
            Map<String, List<BaseFileDTO>> dataFileMap = this.executeRequest(ALL_LATEST_BASE_FILES_BEFORE_ON_INSTANT_URL, paramsMap, BASE_FILE_MAP_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return dataFileMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(BaseFileDTO::toHoodieBaseFile)));
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Option<HoodieBaseFile> getBaseFileOn(String partitionPath, String instantTime, String fileId) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParams(partitionPath, new String[]{INSTANT_PARAM, FILEID_PARAM}, new String[]{instantTime, fileId});
        return Option.fromJavaOptional(this.getLatestBaseFilesFromParams(LATEST_DATA_FILE_ON_INSTANT_URL, paramsMap).findFirst());
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> commitsToReturn) {
        Map<String, String> paramsMap = this.getParams(INSTANTS_PARAM, String.join((CharSequence)MULTI_VALUE_SEPARATOR, commitsToReturn));
        return this.getLatestBaseFilesFromParams(LATEST_DATA_FILES_RANGE_INSTANT_URL, paramsMap);
    }

    @Override
    public Stream<HoodieBaseFile> getAllBaseFiles(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestBaseFilesFromParams(ALL_DATA_FILES_URL, paramsMap);
    }

    @Override
    public Option<HoodieBaseFile> getLatestBaseFile(String partitionPath, String fileId) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, FILEID_PARAM, fileId);
        return Option.fromJavaOptional(this.getLatestBaseFilesFromParams(LATEST_PARTITION_DATA_FILE_URL, paramsMap).findFirst());
    }

    private Stream<FileSlice> getLatestFileSlicesStreamFromParams(String requestPath, Map<String, String> paramsMap) {
        try {
            List<FileSliceDTO> dataFiles = this.executeRequest(requestPath, paramsMap, FILE_SLICE_DTOS_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return dataFiles.stream().map(FileSliceDTO::toFileSlice);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Stream<FileSlice> getLatestFileSlices(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestFileSlicesStreamFromParams(LATEST_PARTITION_SLICES_URL, paramsMap);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesIncludingInflight(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestFileSlicesStreamFromParams(LATEST_PARTITION_SLICES_INFLIGHT_URL, paramsMap);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesStateless(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestFileSlicesStreamFromParams(LATEST_PARTITION_SLICES_STATELESS_URL, paramsMap);
    }

    @Override
    public Option<FileSlice> getLatestFileSlice(String partitionPath, String fileId) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, FILEID_PARAM, fileId);
        return Option.fromJavaOptional(this.getLatestFileSlicesStreamFromParams(LATEST_PARTITION_SLICE_URL, paramsMap).findFirst());
    }

    @Override
    public Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestFileSlicesStreamFromParams(LATEST_PARTITION_UNCOMPACTED_SLICES_URL, paramsMap);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionPath, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParams(partitionPath, new String[]{MAX_INSTANT_PARAM, INCLUDE_FILES_IN_PENDING_COMPACTION_PARAM}, new String[]{maxCommitTime, String.valueOf(includeFileSlicesInPendingCompaction)});
        return this.getLatestFileSlicesStreamFromParams(LATEST_SLICES_BEFORE_ON_INSTANT_URL, paramsMap);
    }

    @Override
    public Map<String, Stream<FileSlice>> getAllLatestFileSlicesBeforeOrOn(String maxCommitTime) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        paramsMap.put(MAX_INSTANT_PARAM, maxCommitTime);
        try {
            Map<String, List<FileSliceDTO>> fileSliceMap = this.executeRequest(ALL_LATEST_SLICES_BEFORE_ON_INSTANT_URL, paramsMap, FILE_SLICE_MAP_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return fileSliceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(FileSliceDTO::toFileSlice)));
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionPath, String maxInstantTime) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, MAX_INSTANT_PARAM, maxInstantTime);
        return this.getLatestFileSlicesStreamFromParams(LATEST_SLICES_MERGED_BEFORE_ON_INSTANT_URL, paramsMap);
    }

    @Override
    public Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        Map<String, String> paramsMap = this.getParams(INSTANTS_PARAM, String.join((CharSequence)MULTI_VALUE_SEPARATOR, commitsToReturn));
        return this.getLatestFileSlicesStreamFromParams(LATEST_SLICES_RANGE_INSTANT_URL, paramsMap);
    }

    @Override
    public Stream<FileSlice> getAllFileSlices(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getLatestFileSlicesStreamFromParams(ALL_SLICES_URL, paramsMap);
    }

    private Stream<HoodieFileGroup> getAllFileGroupsForPartitionFromParams(String requestPath, Map<String, String> paramsMap) {
        try {
            List<FileGroupDTO> fileGroups = this.executeRequest(requestPath, paramsMap, FILE_GROUP_DTOS_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return DTOUtils.fileGroupDTOsToFileGroups(fileGroups, this.metaClient);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroups(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getAllFileGroupsForPartitionFromParams(ALL_FILEGROUPS_FOR_PARTITION_URL, paramsMap);
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroupsStateless(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getAllFileGroupsForPartitionFromParams(ALL_FILEGROUPS_FOR_PARTITION_STATELESS_URL, paramsMap);
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBeforeOrOn(String maxCommitTime, String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, MAX_INSTANT_PARAM, maxCommitTime);
        return this.getAllFileGroupsForPartitionFromParams(ALL_REPLACED_FILEGROUPS_BEFORE_OR_ON_URL, paramsMap);
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBefore(String maxCommitTime, String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, MAX_INSTANT_PARAM, maxCommitTime);
        return this.getAllFileGroupsForPartitionFromParams(ALL_REPLACED_FILEGROUPS_BEFORE_URL, paramsMap);
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsAfterOrOn(String minCommitTime, String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithAdditionalParam(partitionPath, MIN_INSTANT_PARAM, minCommitTime);
        return this.getAllFileGroupsForPartitionFromParams(ALL_REPLACED_FILEGROUPS_AFTER_OR_ON_URL, paramsMap);
    }

    @Override
    public Stream<HoodieFileGroup> getAllReplacedFileGroups(String partitionPath) {
        Map<String, String> paramsMap = this.getParamsWithPartitionPath(partitionPath);
        return this.getAllFileGroupsForPartitionFromParams(ALL_REPLACED_FILEGROUPS_PARTITION_URL, paramsMap);
    }

    public boolean refresh() {
        Map<String, String> paramsMap = this.getParams();
        try {
            this.timeline = this.metaClient.reloadActiveTimeline().filterCompletedAndCompactionInstants();
            return this.executeRequest(REFRESH_TABLE_URL, paramsMap, BOOLEAN_TYPE_REFERENCE, TimelineServiceClientBase.RequestMethod.POST);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    private void loadPartitions(String requestPath, Map<String, String> paramsMap) {
        try {
            this.executeRequest(requestPath, paramsMap, BOOLEAN_TYPE_REFERENCE, TimelineServiceClientBase.RequestMethod.POST);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public void loadAllPartitions() {
        Map<String, String> paramsMap = this.getParams();
        this.loadPartitions(LOAD_ALL_PARTITIONS_URL, paramsMap);
    }

    @Override
    public void loadPartitions(List<String> partitionPaths) {
        Map<String, String> paramsMap = this.getParams();
        try {
            paramsMap.put(PARTITIONS_PARAM, OBJECT_MAPPER.writeValueAsString(partitionPaths));
        }
        catch (JsonProcessingException e) {
            throw new HoodieRemoteException(e);
        }
        this.loadPartitions(LOAD_PARTITIONS_URL, paramsMap);
    }

    private Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations(String requestPath, Map<String, String> paramsMap) {
        try {
            List<CompactionOpDTO> dtos = this.executeRequest(requestPath, paramsMap, COMPACTION_OP_DTOS_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return dtos.stream().map(CompactionOpDTO::toCompactionOperation);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        Map<String, String> paramsMap = this.getParams();
        return this.getPendingCompactionOperations(PENDING_COMPACTION_OPS_URL, paramsMap);
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingLogCompactionOperations() {
        Map<String, String> paramsMap = this.getParams();
        return this.getPendingCompactionOperations(PENDING_LOG_COMPACTION_OPS_URL, paramsMap);
    }

    @Override
    public Stream<Pair<HoodieFileGroupId, HoodieInstant>> getFileGroupsInPendingClustering() {
        Map<String, String> paramsMap = this.getParams();
        try {
            List<ClusteringOpDTO> dtos = this.executeRequest(PENDING_CLUSTERING_FILEGROUPS_URL, paramsMap, CLUSTERING_OP_DTOS_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            InstantGenerator factory = this.metaClient.getInstantGenerator();
            return dtos.stream().map(dto -> ClusteringOpDTO.toClusteringOperation(dto, factory));
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        Map<String, String> paramsMap = this.getParams();
        try {
            List<InstantDTO> instants = this.executeRequest(LAST_INSTANT_URL, paramsMap, INSTANT_DTOS_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return Option.fromJavaOptional(instants.stream().map(dto -> InstantDTO.toInstant(dto, this.metaClient.getInstantGenerator())).findFirst());
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public HoodieTimeline getTimeline() {
        Map<String, String> paramsMap = this.getParams();
        try {
            TimelineDTO timelineDto = this.executeRequest(TIMELINE_URL, paramsMap, TIMELINE_DTO_REFERENCE, TimelineServiceClientBase.RequestMethod.GET);
            return TimelineDTO.toTimeline(timelineDto, this.metaClient);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void reset() {
        this.refresh();
    }

    @Override
    public void sync() {
        this.refresh();
    }
}

