/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.HoodieGlobalBloomIndex;
import org.apache.hudi.index.bloom.ListBasedHoodieBloomIndexHelper;
import org.apache.hudi.index.bucket.HoodieConsistentBucketIndex;
import org.apache.hudi.index.bucket.HoodieSimpleBucketIndex;
import org.apache.hudi.index.simple.HoodieGlobalSimpleIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.index.state.FlinkInMemoryStateIndex;

public final class FlinkHoodieIndexFactory {
    public static HoodieIndex createIndex(HoodieFlinkEngineContext context, HoodieWriteConfig config) {
        if (!StringUtils.isNullOrEmpty(config.getIndexClass())) {
            return HoodieIndexUtils.createUserDefinedIndex(config);
        }
        switch (config.getIndexType()) {
            case FLINK_STATE: 
            case INMEMORY: {
                return new FlinkInMemoryStateIndex(context, config);
            }
            case BLOOM: {
                return new HoodieBloomIndex(config, ListBasedHoodieBloomIndexHelper.getInstance());
            }
            case GLOBAL_BLOOM: {
                return new HoodieGlobalBloomIndex(config, ListBasedHoodieBloomIndexHelper.getInstance());
            }
            case SIMPLE: {
                return new HoodieSimpleIndex(config, Option.empty());
            }
            case GLOBAL_SIMPLE: {
                return new HoodieGlobalSimpleIndex(config, Option.empty());
            }
            case BUCKET: {
                switch (config.getBucketIndexEngineType()) {
                    case SIMPLE: {
                        return new HoodieSimpleBucketIndex(config);
                    }
                    case CONSISTENT_HASHING: {
                        return new HoodieConsistentBucketIndex(config);
                    }
                }
                throw new HoodieIndexException("Unknown bucket index engine type: " + (Object)((Object)config.getBucketIndexEngineType()));
            }
        }
        throw new HoodieIndexException("Unsupported index type " + (Object)((Object)config.getIndexType()));
    }
}

