/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.secondary;

import io.hops.hudi.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.hops.hudi.com.fasterxml.jackson.annotation.PropertyAccessor;
import io.hops.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import io.hops.hudi.com.fasterxml.jackson.core.type.TypeReference;
import io.hops.hudi.com.fasterxml.jackson.databind.DeserializationFeature;
import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieSecondaryIndexException;
import org.apache.hudi.index.secondary.HoodieSecondaryIndex;

public class SecondaryIndexUtils {
    public static Option<List<HoodieSecondaryIndex>> getSecondaryIndexes(HoodieTableMetaClient metaClient) {
        Option<String> indexesMetadata = metaClient.getTableConfig().getSecondaryIndexesMetadata();
        return indexesMetadata.map(SecondaryIndexUtils::fromJsonString);
    }

    public static List<HoodieSecondaryIndex> fromJsonString(String jsonStr) {
        try {
            return SecondaryIndexUtils.fromJsonString(jsonStr, new TypeReference<List<HoodieSecondaryIndex>>(){});
        }
        catch (Exception e) {
            throw new HoodieSecondaryIndexException("Fail to get secondary indexes", e);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return SecondaryIndexUtils.getObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new HoodieIndexException("Fail to convert object to json string", e);
        }
    }

    public static <T> T fromJsonString(String jsonStr, TypeReference<T> type) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return null;
        }
        return SecondaryIndexUtils.getObjectMapper().readValue(jsonStr, type);
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return mapper;
    }
}

