/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.FlinkMergeHandle;
import org.apache.hudi.io.HoodieCDCLogger;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMergeHandleWithChangeLog<T, I, K, O>
extends FlinkMergeHandle<T, I, K, O> {
    private final HoodieCDCLogger cdcLogger;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkMergeHandleWithChangeLog.class);

    public FlinkMergeHandleWithChangeLog(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier);
        this.cdcLogger = new HoodieCDCLogger(instantTime, config, hoodieTable.getMetaClient().getTableConfig(), partitionPath, this.getStorage(), this.getWriterSchema(), this.createLogWriter(instantTime, ".cdc", Option.empty()), IOUtils.getMaxMemoryPerPartitionMerge(taskContextSupplier, config));
    }

    @Override
    protected boolean writeUpdateRecord(HoodieRecord<T> newRecord, HoodieRecord<T> oldRecord, Option<HoodieRecord> combineRecordOpt, Schema writerSchema) throws IOException {
        Option<HoodieRecord> savedCombineRecordOp = combineRecordOpt.map(HoodieRecord::newInstance);
        boolean result = super.writeUpdateRecord(newRecord, oldRecord, combineRecordOpt, writerSchema);
        if (result) {
            boolean isDelete = HoodieOperation.isDelete(newRecord.getOperation());
            Option avroRecordOpt = savedCombineRecordOp.flatMap(r -> FlinkMergeHandleWithChangeLog.toAvroRecord(r, writerSchema, this.config.getPayloadConfig().getProps()));
            this.cdcLogger.put(newRecord, (GenericRecord)oldRecord.getData(), isDelete ? Option.empty() : avroRecordOpt);
        }
        return result;
    }

    @Override
    protected void writeInsertRecord(HoodieRecord<T> newRecord) throws IOException {
        Schema schema = this.preserveMetadata ? this.writeSchemaWithMetaFields : this.writeSchema;
        HoodieRecord<T> savedRecord = newRecord.newInstance();
        super.writeInsertRecord(newRecord);
        if (!HoodieOperation.isDelete(newRecord.getOperation())) {
            this.cdcLogger.put(newRecord, null, savedRecord.toIndexedRecord(schema, this.config.getPayloadConfig().getProps()).map(HoodieRecord::getData));
        }
    }

    @Override
    public List<WriteStatus> close() {
        List<WriteStatus> writeStatuses = super.close();
        this.cdcLogger.close();
        HoodieWriteStat stat = writeStatuses.get(0).getStat();
        stat.setCdcStats(this.cdcLogger.getCDCWriteStats());
        return writeStatuses;
    }
}

