/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.parser.BaseHoodieDateTimeParser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampBasedAvroKeyGenerator
extends SimpleAvroKeyGenerator {
    private final TimeUnit timeUnit;
    private final TimestampType timestampType;
    private final String outputDateFormat;
    private transient Option<DateTimeFormatter> inputFormatter;
    private transient DateTimeFormatter partitionFormatter;
    private final BaseHoodieDateTimeParser parser;
    private final DateTimeZone inputDateTimeZone;
    private final DateTimeZone outputDateTimeZone;
    protected final boolean encodePartitionPath;

    public TimestampBasedAvroKeyGenerator(TypedProperties config) throws IOException {
        this(config, config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    TimestampBasedAvroKeyGenerator(TypedProperties config, String partitionPathField) throws IOException {
        this(config, (String)null, partitionPathField);
    }

    TimestampBasedAvroKeyGenerator(TypedProperties config, String recordKeyField, String partitionPathField) throws IOException {
        super(config, Option.ofNullable(recordKeyField), partitionPathField);
        String dateTimeParserClass = ConfigUtils.getStringWithAltKeys((Properties)config, TimestampKeyGeneratorConfig.DATE_TIME_PARSER, true);
        this.parser = KeyGenUtils.createDateTimeParser(config, dateTimeParserClass);
        this.inputDateTimeZone = this.parser.getInputDateTimeZone();
        this.outputDateTimeZone = this.parser.getOutputDateTimeZone();
        this.outputDateFormat = this.parser.getOutputDateFormat();
        this.timestampType = TimestampType.valueOf(ConfigUtils.getStringWithAltKeys(config, TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD));
        switch (this.timestampType) {
            case EPOCHMILLISECONDS: {
                this.timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case EPOCHMICROSECONDS: {
                this.timeUnit = TimeUnit.MICROSECONDS;
                break;
            }
            case UNIX_TIMESTAMP: {
                this.timeUnit = TimeUnit.SECONDS;
                break;
            }
            case SCALAR: {
                String timeUnitStr = ConfigUtils.getStringWithAltKeys((Properties)config, TimestampKeyGeneratorConfig.INPUT_TIME_UNIT, TimeUnit.SECONDS.toString());
                this.timeUnit = TimeUnit.valueOf(timeUnitStr.toUpperCase());
                break;
            }
            default: {
                this.timeUnit = null;
            }
        }
        this.encodePartitionPath = config.getBoolean(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key(), Boolean.parseBoolean(KeyGeneratorOptions.URL_ENCODE_PARTITIONING.defaultValue()));
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        Object partitionVal = HoodieAvroUtils.getNestedFieldVal(record, this.getPartitionPathFields().get(0), true, this.isConsistentLogicalTimestampEnabled());
        if (partitionVal == null) {
            partitionVal = this.getDefaultPartitionVal();
        }
        try {
            return this.getPartitionPath(partitionVal);
        }
        catch (Exception e) {
            throw new HoodieKeyGeneratorException("Unable to parse input partition field: " + partitionVal, e);
        }
    }

    public Object getDefaultPartitionVal() {
        Long result = 1L;
        if (this.timestampType == TimestampType.DATE_STRING || this.timestampType == TimestampType.MIXED) {
            String delimiter = this.parser.getConfigInputDateFormatDelimiter();
            String format = ConfigUtils.getStringWithAltKeys((Properties)this.config, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT, true).split(delimiter)[0];
            if (null != this.inputDateTimeZone) {
                return new DateTime((Object)result, this.inputDateTimeZone).toString(format);
            }
            if (null != this.outputDateTimeZone) {
                return new DateTime((Object)result, this.outputDateTimeZone).toString(format);
            }
            return new DateTime((Object)result, DateTimeZone.forTimeZone(TimeZone.getTimeZone("GMT"))).toString(format);
        }
        return result;
    }

    private void initIfNeeded() {
        if (this.inputFormatter == null) {
            this.inputFormatter = this.parser.getInputFormatter();
        }
        if (this.partitionFormatter == null) {
            this.partitionFormatter = DateTimeFormat.forPattern(this.outputDateFormat);
            if (this.outputDateTimeZone != null) {
                this.partitionFormatter = this.partitionFormatter.withZone(this.outputDateTimeZone);
            }
        }
    }

    public String getPartitionPath(Object partitionVal) {
        long timeMs;
        this.initIfNeeded();
        if (partitionVal instanceof Double) {
            timeMs = this.convertLongTimeToMillis(((Double)partitionVal).longValue());
        } else if (partitionVal instanceof Float) {
            timeMs = this.convertLongTimeToMillis(((Float)partitionVal).longValue());
        } else if (partitionVal instanceof Long) {
            timeMs = this.convertLongTimeToMillis((Long)partitionVal);
        } else if (partitionVal instanceof Timestamp && this.isConsistentLogicalTimestampEnabled()) {
            timeMs = ((Timestamp)partitionVal).getTime();
        } else if (partitionVal instanceof Integer) {
            timeMs = this.convertLongTimeToMillis(((Integer)partitionVal).longValue());
        } else if (partitionVal instanceof BigDecimal) {
            timeMs = this.convertLongTimeToMillis(((BigDecimal)partitionVal).longValue());
        } else if (partitionVal instanceof LocalDate) {
            timeMs = this.convertLongTimeToMillis(((LocalDate)partitionVal).toEpochDay());
        } else if (partitionVal instanceof CharSequence) {
            if (!this.inputFormatter.isPresent()) {
                throw new HoodieException("Missing input formatter. Ensure " + TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT.key() + " config is set when timestampType is DATE_STRING or MIXED!");
            }
            DateTime parsedDateTime = this.inputFormatter.get().parseDateTime(partitionVal.toString());
            if (this.outputDateTimeZone == null) {
                this.partitionFormatter = this.partitionFormatter.withZone(parsedDateTime.getZone());
            }
            timeMs = this.inputFormatter.get().parseDateTime(partitionVal.toString()).getMillis();
        } else {
            throw new HoodieNotSupportedException("Unexpected type for partition field: " + partitionVal.getClass().getName());
        }
        DateTime timestamp = new DateTime(timeMs, this.outputDateTimeZone);
        String partitionPath = timestamp.toString(this.partitionFormatter);
        if (this.encodePartitionPath) {
            partitionPath = PartitionPathEncodeUtils.escapePathName(partitionPath);
        }
        return this.hiveStylePartitioning ? this.getPartitionPathFields().get(0) + "=" + partitionPath : partitionPath;
    }

    private long convertLongTimeToMillis(Long partitionVal) {
        if (this.timeUnit == null) {
            throw new RuntimeException(TimestampKeyGeneratorConfig.INPUT_TIME_UNIT.key() + " is not specified but scalar it supplied as time value");
        }
        return TimeUnit.MILLISECONDS.convert(partitionVal, this.timeUnit);
    }

    public static enum TimestampType implements Serializable
    {
        UNIX_TIMESTAMP,
        DATE_STRING,
        MIXED,
        EPOCHMILLISECONDS,
        EPOCHMICROSECONDS,
        SCALAR;

    }
}

