/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.hash.BucketIndexUtil;
import org.apache.hudi.index.bucket.BucketIdentifier;

public class BucketIndexPartitioner<T extends HoodieKey>
implements Partitioner<T> {
    private final int bucketNum;
    private final String indexKeyFields;
    private Functions.Function2<String, Integer, Integer> partitionIndexFunc;

    public BucketIndexPartitioner(int bucketNum, String indexKeyFields) {
        this.bucketNum = bucketNum;
        this.indexKeyFields = indexKeyFields;
    }

    public int partition(HoodieKey key, int numPartitions) {
        if (this.partitionIndexFunc == null) {
            this.partitionIndexFunc = BucketIndexUtil.getPartitionIndexFunc(this.bucketNum, numPartitions);
        }
        int curBucket = BucketIdentifier.getBucketId(key, this.indexKeyFields, this.bucketNum);
        return this.partitionIndexFunc.apply(key.getPartitionPath(), curBucket);
    }
}

